/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.common.message;

import com.pedestriamc.common.message.CommonMessage;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class Messenger<T extends Enum<T>> {
    private final EnumMap<T, Object> enumMap;
    private final String prefix;
    private final String strippedPrefix;

    public Messenger(FileConfiguration config, String prefix, Class<T> clazz) {
        this.enumMap = new EnumMap(clazz);
        this.prefix = prefix;
        this.strippedPrefix = ChatColor.stripColor((String)this.translate(prefix));
        for (Enum msg : (Enum[])clazz.getEnumConstants()) {
            String configValue = ((CommonMessage)((Object)msg)).getKey();
            try {
                if (config.isList(configValue)) {
                    this.enumMap.put((T)msg, (Object)config.getStringList(configValue).toArray(new String[0]));
                    continue;
                }
                this.enumMap.put((T)msg, (Object)config.getString(configValue));
            }
            catch (NullPointerException e) {
                Bukkit.getLogger().warning(this.strippedPrefix + " Unable to find message for " + msg);
            }
        }
    }

    public void sendMessage(CommandSender sender, T message) {
        Object obj = this.enumMap.get(message);
        if (obj instanceof String[]) {
            String[] msg;
            for (String str : msg = (String[])obj) {
                sender.sendMessage(this.translate(str));
            }
        } else if (obj instanceof String) {
            sender.sendMessage(this.translate(this.prefix + this.enumMap.get(message)));
        } else {
            Bukkit.getLogger().info(this.strippedPrefix + " Unknown object type or value not found for message " + ((Enum)message).toString());
        }
    }

    public void sendMessage(CommandSender sender, T message, Map<String, String> placeholders) {
        Object msg = this.enumMap.get(message);
        if (msg instanceof String[]) {
            String[] array;
            for (String str : array = (String[])msg) {
                for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                    str = str.replace(entry.getKey(), entry.getValue());
                }
                sender.sendMessage(this.translate(str));
            }
            return;
        }
        if (msg instanceof String) {
            String str = (String)msg;
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                str = str.replace(entry.getKey(), entry.getValue());
            }
            sender.sendMessage(this.translate(this.prefix + str));
            return;
        }
        Bukkit.getLogger().info(this.strippedPrefix + " Unknown object type or value not found for message " + ((Enum)message).toString());
    }

    private String translate(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

