/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.common.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.MapIterator;
import org.jetbrains.annotations.NotNull;

public class UnrestrictedBidiMap<K, V>
implements BidiMap<K, V> {
    private final Map<K, V> regular = new HashMap();
    private final Map<V, K> inverted = new HashMap<V, K>();

    @Override
    public int size() {
        return this.regular.size();
    }

    @Override
    public boolean isEmpty() {
        return this.regular.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.regular.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.regular.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.regular.get(key);
    }

    @Override
    public V put(K key, V value) {
        V val = this.regular.get(key);
        this.regular.put(key, value);
        this.inverted.put(value, key);
        return val;
    }

    @Override
    public V remove(Object key) {
        V val = this.regular.get(key);
        this.inverted.remove(val);
        return this.regular.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        this.regular.putAll(m);
        for (K k : m.keySet()) {
            V val = m.get(k);
            this.inverted.put(val, k);
        }
    }

    @Override
    public void clear() {
        this.regular.clear();
        this.inverted.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.regular.keySet();
    }

    @Override
    public K getKey(Object value) {
        return this.inverted.get(value);
    }

    @Override
    public K removeValue(Object value) {
        K key = this.inverted.get(value);
        if (key != null && this.regular.containsKey(key)) {
            this.regular.remove(key);
        }
        return this.inverted.remove(value);
    }

    @Override
    public BidiMap<V, K> inverseBidiMap() {
        UnrestrictedBidiMap<V, K> map = new UnrestrictedBidiMap<V, K>();
        map.putAll(this.inverted);
        return map;
    }

    @Override
    @NotNull
    public Set<V> values() {
        return new HashSet<V>(this.regular.values());
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.regular.entrySet();
    }

    @Override
    @Deprecated
    public MapIterator<K, V> mapIterator() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("UnrestrictedBidiMap does not implement BidMap#mapIterator().");
    }

    public String toString() {
        return this.regular.toString();
    }

    @Override
    public int hashCode() {
        return this.regular.hashCode();
    }
}

