/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.fonts;

import com.pedestriamc.common.message.Messenger;
import com.pedestriamc.fonts.api.FontsRegistrar;
import com.pedestriamc.fonts.bukkit.Metrics;
import com.pedestriamc.fonts.charts.SimplePie;
import com.pedestriamc.fonts.commands.FontsCommand;
import com.pedestriamc.fonts.commands.font.FontCommand;
import com.pedestriamc.fonts.impl.FontsImpl;
import com.pedestriamc.fonts.listeners.ChatListener;
import com.pedestriamc.fonts.listeners.JoinListener;
import com.pedestriamc.fonts.listeners.LeaveListener;
import com.pedestriamc.fonts.message.Message;
import com.pedestriamc.fonts.tabcompleters.FontTabCompleter;
import com.pedestriamc.fonts.tabcompleters.FontsTabCompleter;
import com.pedestriamc.fonts.text.FontLoader;
import com.pedestriamc.fonts.users.UserUtil;
import com.pedestriamc.fonts.users.YamlUserUtil;
import com.tchristofferson.configupdater.ConfigUpdater;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class Fonts
extends JavaPlugin {
    public static final String DISTRIBUTOR = "modrinth";
    public static final String VERSION = "1.2";
    public static final short VERSION_NUM = 2;
    private FontLoader fontLoader;
    private UserUtil userUtil;
    private FileConfiguration usersConfig;
    private File usersFile;
    private FileConfiguration messagesConfig;
    private Messenger<Message> messenger;

    public void onLoad() {
        this.updateConfigs();
        this.reloadConfig();
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.setupFiles();
        this.createObjects();
        this.registerClasses();
        this.loadUsers();
        this.loadApi();
        this.setupMetrics();
        this.checkUpdate();
        this.log("Fonts version 1.2 loaded.");
    }

    public void onDisable() {
        this.fontLoader = null;
        this.userUtil = null;
        this.usersConfig = null;
        this.messagesConfig = null;
        this.messenger = null;
        HandlerList.unregisterAll((Plugin)this);
        FontsRegistrar.unregister();
    }

    public void reload() {
        this.onDisable();
        this.onEnable();
    }

    private void loadUsers() {
        if (this.userUtil.isEmpty() && !Bukkit.getOnlinePlayers().isEmpty()) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.userUtil.loadUser(p.getUniqueId());
            }
        }
    }

    private void checkUpdate() {
        try {
            HttpsURLConnection connection = (HttpsURLConnection)new URL("https://www.wiicart.net/fonts/version.txt").openConnection();
            connection.setRequestMethod("GET");
            String raw = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
            short latest = Short.parseShort(raw);
            if (latest > 2) {
                Bukkit.getLogger().info("+-------------[Fonts]-------------+");
                Bukkit.getLogger().info("|    A new update is available!   |");
                Bukkit.getLogger().info("|          Download at:           |");
                Bukkit.getLogger().info("|    https://wiicart.net/fonts    |");
                Bukkit.getLogger().info("+---------------------------------+");
            }
        }
        catch (IOException a) {
            Bukkit.getLogger().info("[Strings] Unable to check for updates.");
        }
    }

    private void loadApi() {
        FontsRegistrar.register(new FontsImpl(this));
    }

    private void setupFiles() {
        this.usersFile = new File(this.getDataFolder(), "users.yml");
        if (!this.usersFile.exists()) {
            this.usersFile.getParentFile().mkdirs();
            this.saveResource("users.yml", false);
        }
        this.usersConfig = YamlConfiguration.loadConfiguration((File)this.usersFile);
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            messagesFile.getParentFile().mkdirs();
            this.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    private void createObjects() {
        String prefix = this.getMessagesConfig().getString("prefix");
        if (prefix == null) {
            prefix = "&8[&cFonts&8] &f";
        }
        this.messenger = new Messenger<Message>(this.getMessagesConfig(), prefix, Message.class);
        this.fontLoader = new FontLoader(this);
        this.userUtil = new YamlUserUtil(this);
    }

    private void registerClasses() {
        this.getCommand("font").setExecutor((CommandExecutor)new FontCommand(this));
        this.getCommand("font").setTabCompleter((TabCompleter)new FontTabCompleter(this));
        this.getCommand("fonts").setExecutor((CommandExecutor)new FontsCommand(this));
        this.getCommand("fonts").setTabCompleter((TabCompleter)new FontsTabCompleter());
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new LeaveListener(this), (Plugin)this);
    }

    private void log(String msg) {
        this.getLogger().info(msg);
    }

    private void setupMetrics() {
        int pluginId = 23619;
        new Metrics(this, pluginId).addCustomChart(new SimplePie("distributor", this::getDistributor));
    }

    private void updateConfig(@NotNull String name) {
        File file = new File(this.getDataFolder(), name);
        if (file.exists()) {
            try {
                ConfigUpdater.update((Plugin)this, name, file, new String[0]);
            }
            catch (IOException e) {
                this.getLogger().warning("Failed to update " + name);
            }
        }
    }

    private void updateConfigs() {
        this.updateConfig("config.yml");
        this.updateConfig("messages.yml");
    }

    public void async(@NotNull Runnable runnable) {
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, runnable);
    }

    public FileConfiguration getUsersFileConfig() {
        return this.usersConfig;
    }

    public FontLoader getFontLoader() {
        return this.fontLoader;
    }

    public UserUtil getUserUtil() {
        return this.userUtil;
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    public Messenger<Message> getMessenger() {
        return this.messenger;
    }

    public void saveUsersFile() {
        try {
            this.getUsersFileConfig().save(this.usersFile);
        }
        catch (IOException e) {
            this.getLogger().info("Failed to save users file.");
        }
    }

    public String getDistributor() {
        return DISTRIBUTOR;
    }
}

