/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.fonts.commands;

import com.pedestriamc.common.message.Messenger;
import com.pedestriamc.fonts.Fonts;
import com.pedestriamc.fonts.message.Message;
import com.pedestriamc.fonts.users.User;
import com.pedestriamc.fonts.users.UserUtil;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class AbstractCommand {
    private final Fonts fonts;
    private final Messenger<Message> messenger;
    private final UserUtil userUtil;

    protected AbstractCommand(@NotNull Fonts fonts) {
        this.fonts = fonts;
        this.messenger = fonts.getMessenger();
        this.userUtil = fonts.getUserUtil();
    }

    protected Fonts plugin() {
        return this.fonts;
    }

    protected Messenger<Message> messenger() {
        return this.messenger;
    }

    protected UserUtil userUtil() {
        return this.userUtil;
    }

    protected void sendMessage(@NotNull CommandSender recipient, @NotNull Message message) {
        this.messenger().sendMessage(recipient, message);
    }

    protected void sendMessage(@NotNull CommandSender recipient, @NotNull Message message, @NotNull Map<String, String> placeholders) {
        this.messenger().sendMessage(recipient, message, placeholders);
    }

    protected User getUser(@NotNull Player player) {
        return this.userUtil().getUser(player.getUniqueId());
    }

    protected void saveUser(@NotNull User user) {
        this.userUtil().saveUser(user);
    }
}

