/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.fonts.commands.font;

import com.pedestriamc.common.message.Messenger;
import com.pedestriamc.fonts.Fonts;
import com.pedestriamc.fonts.api.Font;
import com.pedestriamc.fonts.commands.font.ListCommand;
import com.pedestriamc.fonts.commands.font.ResetCommand;
import com.pedestriamc.fonts.message.Message;
import com.pedestriamc.fonts.text.FontLoader;
import com.pedestriamc.fonts.users.User;
import com.pedestriamc.fonts.users.UserUtil;
import java.util.Locale;
import java.util.Map;
import net.wiicart.commands.command.CartCommandExecutor;
import net.wiicart.commands.command.CommandData;
import net.wiicart.commands.command.tree.CommandTree;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontCommand
extends CommandTree
implements CartCommandExecutor {
    private static final Map<String, String> INVALID_USAGE_PLACEHOLDERS = Map.of("{usage}", "/font {font}");
    private final FontLoader loader;
    private final UserUtil userUtil;
    private final Messenger<Message> messenger;

    public FontCommand(@NotNull Fonts fonts) {
        super(THIS, builder -> builder.withChild("list", child -> child.executes(new ListCommand(fonts))).withChild("reset", child -> child.executes(new ResetCommand(fonts))));
        this.loader = fonts.getFontLoader();
        this.userUtil = fonts.getUserUtil();
        this.messenger = fonts.getMessenger();
    }

    @Override
    public void onCommand(@NotNull CommandData data) {
        CommandSender sender = data.sender();
        String[] args = data.args();
        if (this.checkBasicPermsAndNotify(sender)) {
            return;
        }
        if (this.checkArgCountAndNotify(sender, args)) {
            return;
        }
        User target = this.getTargetAndNotify(sender, args);
        if (target == null) {
            return;
        }
        Font font = this.getFontAndNotify(sender, args);
        if (font == null) {
            return;
        }
        target.setFont(font);
        this.userUtil.saveUser(target);
        Map<String, String> placeholders = Map.of("{font_name}", font.getName(), "{user}", target.getName());
        if (!target.getPlayer().equals(sender)) {
            this.messenger.sendMessage(sender, Message.FONT_CHANGED_OTHER, placeholders);
        }
        this.messenger.sendMessage((CommandSender)target.getPlayer(), Message.FONT_CHANGED, placeholders);
    }

    private boolean checkBasicPermsAndNotify(@NotNull CommandSender sender) {
        if (FontCommand.doesNotHaveBasicPerms(sender)) {
            this.messenger.sendMessage(sender, Message.NO_PERMS);
            return true;
        }
        return false;
    }

    private boolean checkArgCountAndNotify(@NotNull CommandSender sender, @NotNull String[] args) {
        return switch (args.length) {
            case 0 -> {
                this.messenger.sendMessage(sender, Message.INVALID_USAGE, INVALID_USAGE_PLACEHOLDERS);
                yield true;
            }
            case 1 -> {
                if (!(sender instanceof Player)) {
                    this.messenger.sendMessage(sender, Message.CONSOLE_MUST_DEFINE_PLAYER);
                    yield true;
                }
                yield false;
            }
            case 2 -> false;
            default -> {
                this.messenger.sendMessage(sender, Message.TOO_MANY_ARGS);
                yield true;
            }
        };
    }

    @Nullable
    private User getTargetAndNotify(@NotNull CommandSender sender, @NotNull String[] args) {
        if (args.length < 2) {
            return this.userUtil.getUser(((Player)sender).getUniqueId());
        }
        if (FontCommand.cantModifyOthers(sender)) {
            this.messenger.sendMessage(sender, Message.CANT_USE_ON_OTHERS);
            return null;
        }
        String name = args[1];
        Player player = Bukkit.getPlayer((String)name);
        if (player == null) {
            this.messenger.sendMessage(sender, Message.PLAYER_NOT_FOUND, Map.of("{user}", name));
            return null;
        }
        return this.userUtil.getUser(player.getUniqueId());
    }

    @Nullable
    private Font getFontAndNotify(@NotNull CommandSender sender, @NotNull String[] args) {
        String name = args[0].toLowerCase(Locale.ROOT);
        Font font = this.loader.getFont(name);
        if (font == null) {
            this.messenger.sendMessage(sender, Message.FONT_NOT_FOUND, Map.of("{font_name}", name));
            return null;
        }
        if (this.doesNotHavePermsForFont(sender, name)) {
            this.messenger.sendMessage(sender, Message.NO_PERMS_FONT, Map.of("{font_name}", name));
            return null;
        }
        return font;
    }

    private boolean doesNotHavePermsForFont(@NotNull CommandSender sender, @NotNull String name) {
        return !sender.isOp() && !sender.hasPermission("*") && !sender.hasPermission("fonts.*") && !sender.hasPermission("fonts.font.*") && !sender.hasPermission("fonts.font." + name);
    }

    static boolean cantModifyOthers(@NotNull CommandSender sender) {
        return !sender.isOp() && !sender.hasPermission("*") && !sender.hasPermission("fonts.*") && !sender.hasPermission("fonts.set.*") && !sender.hasPermission("fonts.set.other");
    }

    static boolean doesNotHaveBasicPerms(@NotNull CommandSender sender) {
        return !sender.isOp() && !sender.hasPermission("*") && !sender.hasPermission("fonts.*") && !sender.hasPermission("fonts.set") && !sender.hasPermission("fonts.set.*");
    }
}

