/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.fonts.tabcompleters;

import com.pedestriamc.fonts.Fonts;
import com.pedestriamc.fonts.api.Font;
import com.pedestriamc.fonts.text.FontLoader;
import java.util.ArrayList;
import java.util.List;
import net.wiicart.commands.tabcomplete.TabCompleteUtil;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontTabCompleter
implements TabCompleter {
    private static final List<String> EMPTY = List.of();
    private final FontLoader loader;

    public FontTabCompleter(@NotNull Fonts fonts) {
        this.loader = fonts.getFontLoader();
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return switch (args.length) {
            case 0 -> this.genList(sender);
            case 1 -> TabCompleteUtil.filter(this.genList(sender), args[0]);
            case 2 -> TabCompleteUtil.filter(this.getOnlinePlayers(), args[1]);
            default -> EMPTY;
        };
    }

    @NotNull
    private List<String> genList(@NotNull CommandSender sender) {
        ArrayList<String> list = new ArrayList<String>(this.loader.getLoadedFonts().stream().filter(font -> font.allows(sender)).map(Font::getName).toList());
        list.add("reset");
        list.add("list");
        return list;
    }

    private List<String> getOnlinePlayers() {
        return Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).toList();
    }
}

