/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.fonts.text;

import com.pedestriamc.common.util.UnrestrictedBidiMap;
import com.pedestriamc.fonts.Fonts;
import com.pedestriamc.fonts.api.Font;
import com.pedestriamc.fonts.text.DefaultFont;
import com.pedestriamc.fonts.text.UnicodeFont;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontLoader {
    private static final Font DEFAULT_FONT = new DefaultFont();
    private final Fonts fonts;
    private final HashMap<String, Font> fontMap;
    private final File fontsFolder;
    private final Font globalDefault;

    @NotNull
    public static Font defaultFont() {
        return DEFAULT_FONT;
    }

    public static boolean isDefault(@Nullable Font font) {
        if (font == null) {
            return false;
        }
        return font instanceof DefaultFont;
    }

    public FontLoader(@NotNull Fonts fonts) {
        this.fonts = fonts;
        this.fontMap = new HashMap();
        this.fontsFolder = new File(fonts.getDataFolder(), "fonts");
        if (!this.fontsFolder.exists()) {
            boolean folderMade = this.fontsFolder.mkdirs();
            if (!folderMade) {
                fonts.getLogger().info("Failed to load fonts folder, disabling.");
                fonts.getServer().getPluginManager().disablePlugin((Plugin)fonts);
            }
            this.saveDefaultFiles();
            fonts.getLogger().info("Fonts folder loaded.");
        }
        this.loadFonts(this.fontsFolder);
        this.globalDefault = this.loadGlobalDefault();
    }

    private void saveDefaultFiles() {
        this.saveFile("README.txt");
        this.saveFile("mono.yml");
        this.saveFile("circled.yml");
        this.saveFile("smallcaps.yml");
        this.saveFile("cyrillic.yml");
        this.saveFile("fraktur.yml");
        this.saveFile("script.yml");
        this.saveFile("script_bold.yml");
    }

    private void saveFile(String file) {
        try {
            this.fonts.saveResource("fonts/" + file, false);
        }
        catch (Exception e) {
            this.fonts.getLogger().info("Failed to save file '" + file + "'");
        }
    }

    @Nullable
    public Font getFont(@NotNull String name) {
        if (!this.fontMap.containsKey("name")) {
            return this.loadFont(name);
        }
        return this.fontMap.get(name);
    }

    public Font getFontOrDefault(@NotNull String name) {
        Font font = this.getFont(name);
        return font != null ? font : DEFAULT_FONT;
    }

    @NotNull
    public Font globalDefault() {
        return this.globalDefault;
    }

    public Set<Font> getLoadedFonts() {
        return new HashSet<Font>(this.fontMap.values());
    }

    private Font loadFont(@NotNull String name) {
        if (name.equalsIgnoreCase("default")) {
            return DEFAULT_FONT;
        }
        File file = new File(this.fontsFolder, name + ".yml");
        if (file.exists() && !file.isDirectory()) {
            try {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                ConfigurationSection section = config.getConfigurationSection("font");
                if (section == null) {
                    this.fonts.getLogger().info("Unable to load font '" + name + "', improper formatting.");
                    return null;
                }
                UnrestrictedBidiMap<Character, String> map = new UnrestrictedBidiMap<Character, String>();
                for (String str : section.getKeys(false)) {
                    if (str.length() == 1) {
                        map.put(Character.valueOf(str.charAt(0)), section.getString(str));
                        continue;
                    }
                    this.fonts.getLogger().info("Keys for fonts must be one character.");
                }
                UnicodeFont font = new UnicodeFont(name, map);
                this.fontMap.put(name, font);
                this.fonts.getLogger().info("Loaded font '" + name + "'.");
                return font;
            }
            catch (Exception e) {
                this.fonts.getLogger().info("Failed to load font '" + name + "'");
            }
        }
        this.fonts.getLogger().info("Failed to load font '" + name + "', file not found.");
        return DEFAULT_FONT;
    }

    private Font loadGlobalDefault() {
        FileConfiguration config = this.fonts.getConfig();
        String defaultName = config.getString("default");
        if (defaultName == null) {
            return DEFAULT_FONT;
        }
        Font font = this.loadFont(defaultName);
        return font != null ? font : DEFAULT_FONT;
    }

    private void loadFonts(@NotNull File file) {
        String[] names = file.list();
        if (names == null) {
            return;
        }
        for (String name : names) {
            if (!name.endsWith(".yml")) continue;
            this.loadFont(name.substring(0, name.length() - 4));
        }
    }
}

