/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.fonts.text;

import com.pedestriamc.fonts.api.Font;
import org.apache.commons.collections4.BidiMap;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class UnicodeFont
implements Font {
    private final BidiMap<Character, String> map;
    private final String name;

    public UnicodeFont(String name, BidiMap<Character, String> map) {
        this.name = name;
        this.map = map;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String translate(@NotNull String str) {
        String temp = "";
        if (str.charAt(0) == '\u00a7') {
            temp = str.substring(0, 2);
            str = str.substring(2);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(temp);
        for (char c : str.toCharArray()) {
            String replacement = (String)this.map.get(Character.valueOf(c));
            if (replacement != null) {
                sb.append(replacement);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public String revert(@NotNull String str) {
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            String replacement = String.valueOf(this.map.getKey(Character.valueOf(c)));
            if (replacement != null) {
                sb.append(replacement);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public boolean allows(@NotNull CommandSender sender) {
        return sender.isOp() || sender.hasPermission("*") || sender.hasPermission("fonts.*") || sender.hasPermission("fonts.font.*") || sender.hasPermission("fonts.font." + this.getName());
    }

    public String toString() {
        return this.name;
    }
}

