/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.fonts.users;

import com.pedestriamc.fonts.api.Font;
import com.pedestriamc.fonts.api.FontsUser;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class User
implements FontsUser {
    private final UUID uuid;
    private final Player player;
    private Font activeFont;

    public User(@NotNull UUID uuid, @Nullable Font activeFont) {
        this.uuid = uuid;
        this.player = Objects.requireNonNull(Bukkit.getPlayer((UUID)uuid));
        this.activeFont = activeFont;
    }

    @NotNull
    public Map<String, String> getData() {
        HashMap<String, String> map = new HashMap<String, String>(1);
        if (this.activeFont != null) {
            map.put("font", this.activeFont.getName());
        }
        return map;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    @Nullable
    public Font getFont() {
        return this.activeFont;
    }

    @NotNull
    public Font getFontOrDefault(@NotNull Font defaultFont) {
        return this.activeFont != null ? this.activeFont : defaultFont;
    }

    @Override
    public void setFont(@Nullable Font activeFont) {
        this.activeFont = activeFont;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.player.getName();
    }
}

