/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.fonts.users;

import com.pedestriamc.fonts.Fonts;
import com.pedestriamc.fonts.api.Font;
import com.pedestriamc.fonts.text.FontLoader;
import com.pedestriamc.fonts.users.User;
import com.pedestriamc.fonts.users.UserUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

public class YamlUserUtil
implements UserUtil {
    private final Fonts fonts;
    private final Map<UUID, User> users = new HashMap<UUID, User>();
    private final FileConfiguration config;
    private final FontLoader fontLoader;

    public YamlUserUtil(@NotNull Fonts fonts) {
        this.fonts = fonts;
        this.config = fonts.getUsersFileConfig();
        this.fontLoader = fonts.getFontLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUser(@NotNull User user) {
        Map<String, String> map = user.getData();
        FileConfiguration fileConfiguration = this.config;
        synchronized (fileConfiguration) {
            this.fonts.async(() -> {
                this.config.set("users." + user.getUuid(), null);
                for (Map.Entry entry : map.entrySet()) {
                    this.config.set("users." + user.getUuid() + "." + (String)entry.getKey(), entry.getValue());
                }
                this.fonts.saveUsersFile();
            });
        }
    }

    @Override
    @NotNull
    public User loadUser(@NotNull UUID uuid) {
        String fontName = this.config.getString("users." + uuid + ".font");
        Font font = null;
        if (fontName != null) {
            font = this.fontLoader.getFont(fontName);
        }
        User user = new User(uuid, font);
        this.users.put(uuid, user);
        return user;
    }

    @Override
    @NotNull
    public CompletableFuture<User> loadUserAsync(@NotNull UUID uuid) {
        CompletableFuture<User> future = new CompletableFuture<User>();
        this.fonts.async(() -> {
            try {
                User user = this.loadUser(uuid);
                future.complete(user);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    @NotNull
    public User getUser(@NotNull UUID uuid) {
        User user = this.users.get(uuid);
        return user != null ? user : this.loadUser(uuid);
    }

    @Override
    public void removeUser(@NotNull UUID uuid) {
        this.users.remove(uuid);
    }

    @Override
    public boolean isEmpty() {
        return this.users.isEmpty();
    }
}

