/*
 * Decompiled with CFR 0.152.
 */
package net.wiicart.commands.command.argument;

import java.util.Arrays;
import java.util.Iterator;
import net.wiicart.commands.command.argument.Argument;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ArgumentSequence
implements Iterable<Argument> {
    public static final ArgumentSequence EMPTY = new ArgumentSequence(new Argument[0]);
    private final Argument[] arguments;

    public ArgumentSequence(Argument ... arguments) {
        this.arguments = arguments;
    }

    @Nullable
    public Argument get(int index) {
        if (this.arguments.length >= index) {
            return this.arguments[index];
        }
        return null;
    }

    public int size() {
        return this.arguments.length;
    }

    public Argument[] arguments() {
        return Arrays.copyOf(this.arguments, this.arguments.length);
    }

    public boolean isBlank() {
        for (Argument argument : this.arguments) {
            if (argument == null) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Iterator<Argument> iterator() {
        return Arrays.stream(this.arguments()).iterator();
    }
}

