/*
 * Decompiled with CFR 0.152.
 */
package net.wiicart.commands.command.tree;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.wiicart.commands.command.CartCommandExecutor;
import net.wiicart.commands.command.CommandData;
import net.wiicart.commands.command.argument.ArgumentSequence;
import net.wiicart.commands.command.tree.CommandTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

final class CommandNodeImpl
implements CommandTree.Node {
    private final String name;
    private final Set<CommandTree.Node> children;
    private final CartCommandExecutor executor;
    private final Set<ArgumentSequence> arguments;
    private final Set<String> aliases;

    CommandNodeImpl(@NotNull String name, @NotNull CartCommandExecutor executor, @NotNull Set<ArgumentSequence> arguments, @NotNull Set<String> aliases, CommandTree.Node ... children) {
        this.name = name;
        this.executor = executor;
        this.arguments = Set.copyOf(arguments);
        this.aliases = Set.copyOf(aliases);
        this.children = new HashSet<CommandTree.Node>(Arrays.asList(children));
    }

    @Override
    public void onCommand(@NotNull CommandData data) {
        this.executor.onCommand(data);
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public Set<CommandTree.Node> children() {
        return new HashSet<CommandTree.Node>(this.children);
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public Set<ArgumentSequence> arguments() {
        return this.arguments;
    }

    @Override
    @NotNull
    public Set<String> aliases() {
        return this.aliases;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }
}

