/*
 * Decompiled with CFR 0.152.
 */
package net.wiicart.commands.command.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.wiicart.commands.command.CartCommandExecutor;
import net.wiicart.commands.command.CommandData;
import net.wiicart.commands.command.argument.ArgumentSequence;
import net.wiicart.commands.command.tree.CommandExecutionException;
import net.wiicart.commands.command.tree.TreeBuilder;
import net.wiicart.commands.tabcomplete.TabCompleteUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CommandTree
implements CommandExecutor,
TabCompleter {
    protected static final This THIS = new This();
    private final Node root;

    @NotNull
    public static TreeBuilder builder() {
        return new TreeBuilder();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static CommandTree from(@NotNull CartCommandExecutor executor) {
        return new CommandTree(CommandTree.builder().executes(executor).build());
    }

    @NotNull
    @Contract(value="_ -> new")
    public static CommandTree single(@NotNull CartCommandExecutor executor) {
        return new CommandTree(CommandTree.builder().executes(executor).build());
    }

    public CommandTree(@NotNull Node root) {
        this.root = root;
    }

    protected CommandTree(@NotNull This marker, @NotNull Consumer<TreeBuilder> b) {
        CommandTree commandTree = this;
        if (!(commandTree instanceof CartCommandExecutor)) {
            throw new ClassCastException("CommandTree must implement CartCommandExecutor when using the \"THIS\" constructor.");
        }
        CartCommandExecutor ex = (CartCommandExecutor)((Object)commandTree);
        TreeBuilder builder = CommandTree.builder();
        builder.executes(ex);
        b.accept(builder);
        this.root = builder.build();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        this.root.onCommand(sender, command, label, args);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return this.root.onTabComplete(sender, command, alias, args);
    }

    public static interface Node
    extends CommandExecutor,
    TabCompleter,
    CartCommandExecutor {
        @Override
        default public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            try {
                if (args.length > 0) {
                    for (Node node : this.children()) {
                        if (!node.matches(args[0])) continue;
                        return node.onCommand(sender, command, label, Arrays.copyOfRange(args, 1, args.length));
                    }
                }
                this.onCommand(new CommandData(args, sender, label, command));
            }
            catch (Exception e) {
                if (e instanceof CommandExecutionException) {
                    CommandExecutionException ex = (CommandExecutionException)e;
                    throw ex.addNode(this.name());
                }
                throw new CommandExecutionException(e).addNode(this.name());
            }
            return true;
        }

        default public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.name());
            if (args.length == 0) {
                return list;
            }
            if (args.length == 1) {
                return TabCompleteUtil.filter(list, args[0]);
            }
            for (Node node : this.children()) {
                if (!node.matches(args[1])) continue;
                return node.onTabComplete(sender, command, alias, Arrays.copyOfRange(args, 1, args.length));
            }
            return list;
        }

        default public boolean matches(@NotNull String arg) {
            for (String str : this.aliases()) {
                if (!str.equalsIgnoreCase(arg)) continue;
                return true;
            }
            return this.name().equalsIgnoreCase(arg);
        }

        @NotNull
        public String name();

        @NotNull
        public Set<Node> children();

        @ApiStatus.Experimental
        @NotNull
        public Set<ArgumentSequence> arguments();

        @NotNull
        public Set<String> aliases();

        public boolean isLeaf();
    }

    protected static class This {
        private This() {
        }
    }
}

