/*
 * Decompiled with CFR 0.152.
 */
package net.wiicart.commands.command.tree;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.wiicart.commands.command.CartCommandExecutor;
import net.wiicart.commands.command.tree.CommandNodeImpl;
import net.wiicart.commands.command.tree.CommandTree;
import net.wiicart.commands.command.tree.Workbench;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class TreeBuilder {
    private String name;
    private final Workbench bench;
    private final Set<String> aliases = new HashSet<String>();
    private final Map<String, Consumer<TreeBuilder>> children = new HashMap<String, Consumer<TreeBuilder>>();
    private CartCommandExecutor executor = CartCommandExecutor.EMPTY;

    TreeBuilder() {
        this("ROOT", new Workbench());
    }

    private TreeBuilder(@NotNull String name, @NotNull Workbench bench) {
        this.name = name;
        this.bench = bench;
    }

    @NotNull
    public TreeBuilder workbench(@NotNull Consumer<Workbench> consumer) {
        consumer.accept(this.bench);
        return this;
    }

    public TreeBuilder run(@NotNull Consumer<TreeBuilder> consumer) {
        consumer.accept(this);
        return this;
    }

    @NotNull
    public Workbench getWorkbench() {
        return this.bench;
    }

    public TreeBuilder withChild(@NotNull String name, @NotNull Consumer<TreeBuilder> builder) {
        this.children.put(name.toLowerCase(Locale.ROOT), builder);
        return this;
    }

    public TreeBuilder executes(@NotNull CartCommandExecutor executor) {
        this.executor = executor;
        return this;
    }

    public TreeBuilder executes(@NotNull String name) {
        this.executor = this.bench.retrieve(CartCommandExecutor.class, name);
        return this;
    }

    public TreeBuilder named(@NotNull String name) {
        if (!this.name.equals("ROOT")) {
            this.name = name;
        }
        return this;
    }

    public TreeBuilder withAliases(String ... aliases) {
        this.aliases.addAll(Arrays.asList(aliases));
        return this;
    }

    @Contract(value="-> new")
    @NotNull
    public CommandTree.Node build() {
        HashSet<CommandTree.Node> constructedChildren = new HashSet<CommandTree.Node>();
        for (Map.Entry<String, Consumer<TreeBuilder>> entry : this.children.entrySet()) {
            String childName = entry.getKey();
            Consumer<TreeBuilder> consumer = entry.getValue();
            TreeBuilder child = new TreeBuilder(childName, this.bench);
            consumer.accept(child);
            constructedChildren.add(child.build());
        }
        return new CommandNodeImpl(this.name, this.executor, Set.of(), this.aliases, constructedChildren.toArray(new CommandTree.Node[0]));
    }
}

