/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.screen;

import io.github.mortuusars.scholar.Config;
import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.client.gui.widget.textbox.TextBox;
import io.github.mortuusars.scholar.client.gui.widget.textbox.display.HorizontalAlignment;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedString;
import io.github.mortuusars.scholar.client.util.RenderUtil;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class BookSigningScreen
extends class_437 {
    public static final class_2960 TEXTURE = Scholar.resource("textures/gui/book_signing.png");
    @NotNull
    protected final class_310 minecraft;
    @NotNull
    protected final class_1657 player;
    protected final class_437 parentScreen;
    protected final int bookColor;
    protected final Consumer<String> onSign;
    protected int textColor;
    protected int selectionColor;
    protected int selectionUnfocusedColor;
    protected int enterBookTitleFontColor;
    protected int byAuthorFontColor;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    protected int textureWidth;
    protected int textureHeight;
    protected TextBox titleTextBox;
    protected class_344 signButton;
    protected class_344 cancelSigningButton;
    protected String titleText = "";

    public BookSigningScreen(class_437 parentScreen, int bookColor, Consumer<String> onSign) {
        super((class_2561)class_2561.method_43473());
        this.parentScreen = parentScreen;
        this.bookColor = bookColor;
        this.onSign = onSign;
        this.textColor = Config.Client.getColor(Config.Client.TEXT_COLOR);
        this.selectionColor = Config.Client.getColor(Config.Client.SELECTION_COLOR);
        this.selectionUnfocusedColor = Config.Client.getColor(Config.Client.SELECTION_UNFOCUSED_COLOR);
        this.enterBookTitleFontColor = Config.Client.getColor(Config.Client.ENTER_TITLE_COLOR);
        this.byAuthorFontColor = Config.Client.getColor(Config.Client.BY_AUTHOR_COLOR);
        this.minecraft = class_310.method_1551();
        this.player = (class_1657)Objects.requireNonNull(this.minecraft.field_1724);
        this.textureWidth = 256;
        this.textureHeight = 256;
    }

    public boolean method_25421() {
        return (Boolean)Config.Client.SCREEN_PAUSE.get();
    }

    protected void method_25426() {
        this.imageWidth = 149;
        this.imageHeight = 180;
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        this.titleTextBox = new TextBox(this.field_22793, this.leftPos + 21, this.topPos + 71, 108, 9).setFontColor(this.textColor).setFontUnfocusedColor(this.textColor).setSelectionColor(this.selectionColor).setSelectionUnfocusedColor(this.selectionUnfocusedColor).setHorizontalAlignment(HorizontalAlignment.CENTER).setOnTextChanged(this::setTitleText).setTextValidator(text -> text != null && this.field_22793.method_1713(text, 108) <= 9 && !text.contains("\n"));
        this.method_37063((class_364)this.titleTextBox);
        this.signButton = new class_344(this.leftPos + 46, this.topPos + 108, 22, 22, 149, 0, 22, TEXTURE, this.textureWidth, this.textureHeight, b -> this.signAlbum(), (class_2561)class_2561.method_43471((String)"book.finalizeButton"));
        class_5250 component = class_2561.method_43471((String)"book.finalizeButton").method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"book.finalizeWarning").method_27692(class_124.field_1080));
        this.signButton.method_47400(class_7919.method_47407((class_2561)component));
        this.method_37063((class_364)this.signButton);
        this.cancelSigningButton = new class_344(this.leftPos + 83, this.topPos + 108, 22, 22, 171, 0, 22, TEXTURE, this.textureWidth, this.textureHeight, b -> this.cancelSigning(), class_5244.field_24335);
        this.cancelSigningButton.method_47400(class_7919.method_47407((class_2561)class_5244.field_24335));
        this.method_37063((class_364)this.cancelSigningButton);
        this.method_48265((class_364)this.titleTextBox);
    }

    protected void setTitleText(FormattedString text) {
        this.titleText = text.toString();
        this.updateButtons();
    }

    protected void updateButtons() {
        this.signButton.field_22763 = this.canSign();
    }

    protected boolean canSign() {
        return !this.titleText.isBlank();
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateButtons();
        this.method_25420(guiGraphics);
        RenderUtil.withColorMultiplied(this.bookColor, () -> guiGraphics.method_25291(TEXTURE, this.leftPos, this.topPos, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.textureWidth, this.textureHeight));
        guiGraphics.method_25291(TEXTURE, this.leftPos, this.topPos + 31, 0, 0.0f, 180.0f, this.imageWidth, 76, this.textureWidth, this.textureHeight);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics);
    }

    protected void renderLabels(class_332 guiGraphics) {
        class_5250 component = class_2561.method_43471((String)"book.editTitle");
        guiGraphics.method_51439(this.field_22793, (class_2561)component, this.leftPos + 74 - this.field_22793.method_27525((class_5348)component) / 2, this.topPos + 51, this.enterBookTitleFontColor, false);
        component = class_2561.method_43469((String)"book.byAuthor", (Object[])new Object[]{this.player.method_5477()});
        guiGraphics.method_51439(this.field_22793, (class_2561)component, this.leftPos + 74 - this.field_22793.method_27525((class_5348)component) / 2, this.topPos + 81, this.byAuthorFontColor, false);
    }

    protected void signAlbum() {
        if (this.canSign()) {
            this.onSign.accept(this.titleText.trim());
            this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)Scholar.SoundEvents.BOOK_SIGNED.get(), (float)1.0f, (float)0.8f));
            this.method_25419();
        }
    }

    protected void cancelSigning() {
        this.minecraft.method_1507(this.parentScreen);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.cancelSigning();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

