/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.screen.edit;

import com.google.common.base.Preconditions;
import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.ScholarClient;
import io.github.mortuusars.scholar.book.BookColor;
import io.github.mortuusars.scholar.book.Spread;
import io.github.mortuusars.scholar.client.gui.screen.BookSigningScreen;
import io.github.mortuusars.scholar.client.gui.screen.SpreadBookScreen;
import io.github.mortuusars.scholar.client.gui.widget.textbox.TextBox;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.Char;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedString;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedStringEditor;
import io.github.mortuusars.scholar.client.util.FileDialogs;
import io.github.mortuusars.scholar.client.util.RenderUtil;
import io.github.mortuusars.scholar.util.Change;
import io.github.mortuusars.scholar.util.History;
import io.netty.util.internal.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2820;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_3872;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpreadBookEditScreen
extends SpreadBookScreen {
    protected final class_1799 bookStack;
    protected final class_1268 hand;
    protected final List<String> pages = new ArrayList<String>();
    protected final History history = new History();
    protected TextBox rightPageTextBox;
    protected TextBox leftPageTextBox;
    protected class_344 insertEmptyPageLeftButton;
    protected class_344 removePageLeftButton;
    protected class_344 insertEmptyPageRightButton;
    protected class_344 removePageRightButton;
    protected class_344 exportBookButton;
    protected class_344 importBookButton;
    protected boolean bookModified;

    public SpreadBookEditScreen(class_1799 bookStack, class_1268 hand) {
        super(BookColor.of(bookStack));
        this.bookStack = bookStack;
        this.hand = hand;
    }

    public History getHistory() {
        return this.history;
    }

    protected void setupPages(class_1799 bookStack) {
        this.pages.clear();
        class_2487 compoundtag = bookStack.method_7969();
        if (compoundtag != null) {
            class_3872.method_33888((class_2487)compoundtag, this.pages::add);
        }
        while (this.pages.size() < 2) {
            this.pages.add("");
        }
        this.setTextBoxes(false);
    }

    @Override
    protected void createWidgets() {
        this.leftPageTextBox = new TextBox(this.field_22793, this.leftPos + 22, this.topPos + 21, 114, 128).setFontColor(this.textColor).setFontUnfocusedColor(this.textColor).setSelectionColor(this.selectionColor).setSelectionUnfocusedColor(this.selectionUnfocusedColor).setText(FormattedString.parse(this.getPageText(Spread.Side.LEFT))).setOnTextChanged(text -> this.setPageText(Spread.Side.LEFT, text.toString()));
        this.method_37063((class_364)this.leftPageTextBox);
        this.rightPageTextBox = new TextBox(this.field_22793, this.leftPos + 159, this.topPos + 21, 114, 128).setFontColor(this.textColor).setFontUnfocusedColor(this.textColor).setSelectionColor(this.selectionColor).setSelectionUnfocusedColor(this.selectionUnfocusedColor).setText(FormattedString.parse(this.getPageText(Spread.Side.RIGHT))).setOnTextChanged(text -> this.setPageText(Spread.Side.RIGHT, text.toString()));
        this.method_37063((class_364)this.rightPageTextBox);
        this.setupPages(this.bookStack);
        this.createPageToolButtons();
        this.createPrevPageButton();
        this.createNextPageButton();
        this.createImportExportButtons();
        class_344 enterSignModeButton = new class_344(this.leftPos - 24, this.topPos + 18, 22, 22, 321, 0, 22, TEXTURE, 512, 512, b -> this.enterSignMode(), (class_2561)class_2561.method_43471((String)"book.signButton"));
        enterSignModeButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"book.signButton")));
        this.method_37063((class_364)enterSignModeButton);
        this.createBottomButtons();
    }

    protected void createPageToolButtons() {
        this.insertEmptyPageLeftButton = new class_344(this.leftPos + 112, this.topPos + 154, 13, 13, 343, 0, 13, TEXTURE, 512, 512, b -> this.insertEmptyPage(Spread.Side.LEFT), (class_2561)class_2561.method_43471((String)"gui.scholar.insert_empty_page"));
        this.insertEmptyPageLeftButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.scholar.insert_empty_page").method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"gui.scholar.insert_empty_page_left.hotkey"))));
        this.method_37063((class_364)this.insertEmptyPageLeftButton);
        this.removePageLeftButton = new class_344(this.leftPos + 126, this.topPos + 154, 13, 13, 356, 0, 13, TEXTURE, 512, 512, b -> this.removePage(Spread.Side.LEFT), (class_2561)class_2561.method_43471((String)"gui.scholar.remove_page"));
        this.removePageLeftButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.scholar.remove_page").method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"gui.scholar.remove_page_left.hotkey"))));
        this.method_37063((class_364)this.removePageLeftButton);
        this.insertEmptyPageRightButton = new class_344(this.leftPos + 156, this.topPos + 154, 13, 13, 343, 0, 13, TEXTURE, 512, 512, b -> this.insertEmptyPage(Spread.Side.RIGHT), (class_2561)class_2561.method_43471((String)"gui.scholar.insert_empty_page"));
        this.insertEmptyPageRightButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.scholar.insert_empty_page").method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"gui.scholar.insert_empty_page_right.hotkey"))));
        this.method_37063((class_364)this.insertEmptyPageRightButton);
        this.removePageRightButton = new class_344(this.leftPos + 170, this.topPos + 154, 13, 13, 356, 0, 13, TEXTURE, 512, 512, b -> this.removePage(Spread.Side.RIGHT), (class_2561)class_2561.method_43471((String)"gui.scholar.remove_page"));
        this.removePageRightButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.scholar.remove_page").method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"gui.scholar.remove_page_right.hotkey"))));
        this.method_37063((class_364)this.removePageRightButton);
    }

    protected void createImportExportButtons() {
        this.importBookButton = new class_344(this.leftPos + 297, this.topPos + 16, 18, 18, 387, 0, 18, TEXTURE, 512, 512, b -> this.importBook(class_437.method_25442()), (class_2561)class_2561.method_43471((String)"gui.scholar.import_book"));
        this.importBookButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.scholar.import_book").method_10852((class_2561)ScholarClient.KeyMappings.componentForTooltip(ScholarClient.KeyMappings.importBook)).method_10852(class_5244.field_33849).method_10852((class_2561)class_2561.method_43471((String)"gui.scholar.import_book.tooltip"))));
        this.method_37063((class_364)this.importBookButton);
        this.exportBookButton = new class_344(this.leftPos + 297, this.topPos + 41, 18, 18, 369, 0, 18, TEXTURE, 512, 512, b -> this.exportBook(class_437.method_25442()), (class_2561)class_2561.method_43471((String)"gui.scholar.export_book"));
        this.exportBookButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.scholar.export_book").method_10852((class_2561)ScholarClient.KeyMappings.componentForTooltip(ScholarClient.KeyMappings.exportBook)).method_10852(class_5244.field_33849).method_10852((class_2561)class_2561.method_43471((String)"gui.scholar.export_book.tooltip"))));
        this.method_37063((class_364)this.exportBookButton);
    }

    @Override
    protected void toggleBookTools() {
        super.toggleBookTools();
        this.playButtonClickSound();
    }

    @Override
    protected void updateButtonVisibility() {
        super.updateButtonVisibility();
        this.insertEmptyPageLeftButton.field_22764 = this.isToolsVisible();
        this.insertEmptyPageLeftButton.field_22763 = this.canInsertEmptyPage(Spread.Side.LEFT);
        this.insertEmptyPageRightButton.field_22764 = this.isToolsVisible();
        this.insertEmptyPageRightButton.field_22763 = this.canInsertEmptyPage(Spread.Side.RIGHT);
        this.removePageLeftButton.field_22764 = this.isToolsVisible();
        this.removePageLeftButton.field_22763 = this.canRemovePage(Spread.Side.LEFT);
        this.removePageRightButton.field_22764 = this.isToolsVisible();
        this.removePageRightButton.field_22763 = this.canRemovePage(Spread.Side.RIGHT);
        this.exportBookButton.field_22764 = this.isToolsVisible();
        this.exportBookButton.field_22763 = this.pages.stream().anyMatch(p -> !p.isEmpty());
        this.importBookButton.field_22764 = this.isToolsVisible();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateButtonVisibility();
        this.method_25420(guiGraphics);
        this.renderBook(guiGraphics, mouseX, mouseY, partialTick);
        this.renderPageNumbers(guiGraphics, mouseX, mouseY, partialTick, this.currentSpread);
        this.renderTools(guiGraphics, mouseX, mouseY, partialTick);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderBook(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtil.withColorMultiplied(this.bookColor, () -> {
            if (this.isToolsVisible()) {
                guiGraphics.method_25290(TEXTURE, this.leftPos + 295, this.topPos + 14, 0.0f, 388.0f, 23, 48, 512, 512);
            }
            guiGraphics.method_25293(TEXTURE, (this.field_22789 - 295) / 2, (this.field_22790 - 180) / 2, 295, 180, 0.0f, 0.0f, 295, 180, 512, 512);
            guiGraphics.method_25290(TEXTURE, this.leftPos - 29, this.topPos + 14, 0.0f, 360.0f, 29, 28, 512, 512);
        });
        guiGraphics.method_25293(TEXTURE, (this.field_22789 - 295) / 2, (this.field_22790 - 180) / 2, 295, 180, 0.0f, 180.0f, 295, 180, 512, 512);
    }

    @Override
    protected void renderTools(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = this.field_22789 - 12;
        int y = 6;
        guiGraphics.method_25303(this.field_22793, "?", x, y, -5592406);
        if (mouseX >= x - 3 && mouseX < x + 12 + 3 && mouseY >= y - 3 && mouseY < y + 12) {
            ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
            tooltip.add(class_2561.method_43471((String)"gui.scholar.tools.toggle").method_10852((class_2561)ScholarClient.KeyMappings.componentForTooltip(ScholarClient.KeyMappings.toggleBookTools)));
            tooltip.add(class_2561.method_43471((String)"gui.scholar.tools.tooltip.copy_with_formatting"));
            tooltip.add(class_2561.method_43471((String)"gui.scholar.tools.tooltip.paste_with_formatting"));
            tooltip.add(class_2561.method_43471((String)"gui.scholar.tools.tooltip.undo"));
            tooltip.add(class_2561.method_43471((String)"gui.scholar.tools.tooltip.redo"));
            guiGraphics.method_51437(this.field_22793, tooltip, Optional.empty(), mouseX, mouseY + 20);
        }
    }

    @Override
    public boolean method_25404(int key, int scanCode, int modifiers) {
        TextBox textBox;
        if (ScholarClient.KeyMappings.importBook.method_1417(key, scanCode)) {
            this.playButtonClickSound();
            this.importBook(class_437.method_25442());
            return true;
        }
        if (ScholarClient.KeyMappings.exportBook.method_1417(key, scanCode)) {
            this.playButtonClickSound();
            this.exportBook(class_437.method_25442());
            return true;
        }
        if (class_437.method_25441() && key == 90 && !class_437.method_25443()) {
            Change change;
            float pitch = class_437.method_25442() ? ((change = this.getHistory().redo()) == null ? 1.4f : 0.8f) : ((change = this.getHistory().undo()) == null ? 1.8f : 0.95f);
            this.playButtonClickSound(pitch);
            return true;
        }
        class_364 pitch = this.method_25399();
        if (!(pitch instanceof TextBox && (textBox = (TextBox)pitch).getEditor().isSelecting() || key != 67 || !class_437.method_25441() || class_437.method_25443())) {
            String bookContents = this.getBookContents(class_437.method_25442());
            class_310.method_1551().field_1774.method_1455(bookContents);
            return true;
        }
        if (class_437.method_25441() && class_437.method_25442() && key == 260) {
            this.insertEmptyPage(class_437.method_25443() ? Spread.Side.RIGHT : Spread.Side.LEFT);
            return true;
        }
        if (class_437.method_25441() && class_437.method_25442() && key == 261) {
            this.removePage(class_437.method_25443() ? Spread.Side.RIGHT : Spread.Side.LEFT);
            return true;
        }
        return super.method_25404(key, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int x = this.field_22789 - 12;
        int y = 6;
        if (mouseX >= (double)(x - 3) && mouseX < (double)(x + 12 + 3) && mouseY >= (double)(y - 3) && mouseY < (double)(y + 12)) {
            this.toggleBookTools();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    protected boolean pageForward() {
        if (super.pageForward()) {
            while (this.pages.size() < (this.currentSpread + 1) * 2) {
                this.appendEmptyPage();
            }
            this.setTextBoxes();
            this.getHistory().add(() -> {
                super.pageForward();
                this.setTextBoxes();
            }, () -> {
                super.pageBack();
                this.setTextBoxes();
            });
            return true;
        }
        return false;
    }

    @Override
    protected boolean pageBack() {
        if (super.pageBack()) {
            this.setTextBoxes();
            this.getHistory().add(() -> {
                super.pageBack();
                this.setTextBoxes();
            }, () -> {
                super.pageForward();
                this.setTextBoxes();
            });
            return true;
        }
        return false;
    }

    protected void setTextBoxes() {
        this.setTextBoxes(true);
    }

    protected void setTextBoxes(boolean resetCursor) {
        FormattedString leftString = FormattedString.parse(this.getPageText(Spread.Side.LEFT));
        if (!leftString.equals(this.leftPageTextBox.getEditor().getString())) {
            this.leftPageTextBox.getEditor().setString(leftString);
            int leftCursorPos = resetCursor ? 0 : this.leftPageTextBox.getEditor().getCursorPos();
            this.leftPageTextBox.getEditor().setCursorPos(leftCursorPos, false);
        }
        this.leftPageTextBox.getDisplayCache().scheduleUpdate();
        FormattedString rightString = FormattedString.parse(this.getPageText(Spread.Side.RIGHT));
        if (!rightString.equals(this.rightPageTextBox.getEditor().getString())) {
            this.rightPageTextBox.getEditor().setString(rightString);
            int rightCursorPos = resetCursor ? 0 : this.rightPageTextBox.getEditor().getCursorPos();
            this.rightPageTextBox.getEditor().setCursorPos(rightCursorPos, false);
        }
        this.rightPageTextBox.getDisplayCache().scheduleUpdate();
    }

    protected void enterSignMode() {
        this.saveChanges(false, null);
        this.minecraft.execute(() -> this.minecraft.method_1507((class_437)new BookSigningScreen(this, this.bookColor, title -> this.saveChanges(true, (String)title))));
    }

    protected String getPageText(Spread.Side side) {
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        return pageIndex >= 0 && pageIndex < this.pages.size() ? this.pages.get(pageIndex) : "";
    }

    protected void setPageText(Spread.Side side, String text) {
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        while (pageIndex > this.pages.size() - 1 && pageIndex < this.getPageCount()) {
            this.appendEmptyPage();
        }
        if (pageIndex >= 0 && pageIndex < this.pages.size()) {
            String currentText = this.getPageText(side);
            this.getHistory().add(() -> {
                this.pages.set(pageIndex, text);
                this.bookModified = true;
                this.setTextBoxes(false);
            }, () -> {
                this.pages.set(pageIndex, currentText);
                this.bookModified = true;
                this.setTextBoxes(false);
            });
            this.pages.set(pageIndex, text);
            this.bookModified = true;
        }
    }

    protected void appendEmptyPage() {
        if (this.pages.size() < 100) {
            this.pages.add("");
        }
    }

    protected void insertEmptyPage(Spread.Side side) {
        if (!this.canInsertEmptyPage(side)) {
            Objects.requireNonNull(class_310.method_1551().field_1724).method_7353((class_2561)class_2561.method_43471((String)"gui.scholar.cannot_insert_page"), false);
            return;
        }
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        Change change = Change.create(() -> {
            this.pages.add(pageIndex, "");
            while (this.pages.size() >= 100) {
                this.pages.remove(this.pages.size() - 1);
            }
            this.setTextBoxes();
            this.bookModified = true;
            this.playPageTurnSound(1.0f, 0.6f);
        }, () -> {
            this.pages.remove(pageIndex);
            this.setTextBoxes();
            this.bookModified = true;
            this.playPageTurnSound(1.0f, 0.8f);
        });
        change.apply();
        this.getHistory().add(change);
    }

    protected void removePage(Spread.Side side) {
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        String pageContent = this.pages.get(pageIndex);
        Change change = Change.create(() -> {
            this.pages.remove(pageIndex);
            while (this.pages.size() < Spread.Side.RIGHT.getPageIndexFromSpread(this.currentSpread) + 1) {
                this.pages.add("");
            }
            this.setTextBoxes();
            this.bookModified = true;
            this.playPageTurnSound(0.85f, 0.6f);
        }, () -> {
            this.pages.add(pageIndex, pageContent);
            this.setTextBoxes();
            this.bookModified = true;
            this.playPageTurnSound(0.85f, 0.8f);
        });
        change.apply();
        this.getHistory().add(change);
    }

    protected void saveChanges(boolean sign, @Nullable String title) {
        if (this.bookModified || sign) {
            if (!sign) {
                title = null;
            }
            this.removeEmptyTrailingPages();
            this.updateLocalCopy(sign, title);
            this.sendChanges(title);
        }
    }

    protected void sendChanges(@Nullable String title) {
        int slotId = this.hand == class_1268.field_5808 ? this.player.method_31548().field_7545 : 40;
        Objects.requireNonNull(this.minecraft.method_1562()).method_2883((class_2596)new class_2820(slotId, this.pages, Optional.ofNullable(title)));
    }

    protected void removeEmptyTrailingPages() {
        ListIterator<String> iterator = this.pages.listIterator(this.pages.size());
        while (iterator.hasPrevious() && iterator.previous().isEmpty()) {
            iterator.remove();
        }
    }

    protected void updateLocalCopy(boolean sign, @Nullable String title) {
        class_2499 listTag = new class_2499();
        this.pages.stream().map(class_2519::method_23256).forEach(arg_0 -> listTag.add(arg_0));
        if (!this.pages.isEmpty()) {
            this.bookStack.method_7959("pages", (class_2520)listTag);
        }
        if (sign) {
            Preconditions.checkState((!StringUtil.isNullOrEmpty((String)title) ? 1 : 0) != 0, (Object)"Title cannot be null or empty when signing a book.");
            this.bookStack.method_7959("author", (class_2520)class_2519.method_23256((String)this.player.method_7334().getName()));
            this.bookStack.method_7959("title", (class_2520)class_2519.method_23256((String)title));
        }
    }

    protected boolean canInsertEmptyPage(Spread.Side side) {
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        int lastPageWithContent = this.getLastPageWithContent().orElse(-1);
        return lastPageWithContent < 99 && pageIndex <= lastPageWithContent;
    }

    protected boolean canRemovePage(Spread.Side side) {
        return this.containsContentAfter(side.getPageIndexFromSpread(this.currentSpread));
    }

    protected OptionalInt getLastPageWithContent() {
        for (int i = this.pages.size() - 1; i >= 0; --i) {
            if (this.pages.get(i).isEmpty()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    protected boolean containsContentAfter(int pageIndex) {
        return this.pages.stream().skip(pageIndex).anyMatch(p -> !p.isEmpty());
    }

    public String getBookContents(boolean withFormatting) {
        String contents = String.join((CharSequence)"\n", this.pages);
        if (!withFormatting) {
            class_124.method_539((String)contents);
        }
        return contents;
    }

    public void setBookContents(String contents, boolean withFormatting) {
        ArrayList<String> oldPages = new ArrayList<String>(this.pages);
        this.pages.clear();
        contents = contents.replaceAll("\\r", "");
        if (!withFormatting) {
            contents = class_124.method_539((String)contents);
            assert (contents != null);
        }
        String[] pages = contents.split("\f");
        Predicate<String> validator = FormattedStringEditor.Validator.fitInDimensions(this.field_22793, this.leftPageTextBox.method_25368(), this.leftPageTextBox.method_25364());
        for (String pageContent : pages) {
            if (pageContent.isEmpty()) {
                this.pages.add("");
                continue;
            }
            FormattedString string = FormattedString.parse(pageContent);
            int currentChar = 0;
            FormattedString currentString = new FormattedString();
            String lastValidString = "";
            while (currentChar < string.length()) {
                currentString.add((Char)string.get(currentChar));
                ++currentChar;
                String str = currentString.toString();
                if (!validator.test(str)) {
                    this.pages.add(lastValidString);
                    if (this.pages.size() >= 100) {
                        lastValidString = "";
                        break;
                    }
                    --currentChar;
                    currentString.clear();
                    continue;
                }
                lastValidString = str;
            }
            if (lastValidString.isEmpty() || this.pages.size() > 100) continue;
            this.pages.add(lastValidString);
        }
        this.bookModified = true;
        this.setTextBoxes();
        ArrayList<String> newPages = new ArrayList<String>(this.pages);
        this.getHistory().add(() -> {
            this.pages.clear();
            this.pages.addAll(newPages);
            this.bookModified = true;
            this.setTextBoxes();
        }, () -> {
            this.pages.clear();
            this.pages.addAll(oldPages);
            this.bookModified = true;
            this.setTextBoxes();
        });
    }

    public void importBook(boolean withFormatting) {
        CompletableFuture.runAsync(() -> {
            Object defaultDirectory = class_310.method_1551().field_1697.toPath().toAbsolutePath().normalize().toString();
            if (!((String)defaultDirectory).endsWith(File.separator)) {
                defaultDirectory = (String)defaultDirectory + File.separator;
            }
            String title = class_2561.method_43471((String)"gui.scholar.import_book").getString();
            FileDialogs.loadFile((String)defaultDirectory, title, "Text Files (.txt)", false, "*.txt").ifPresent(filePath -> {
                try {
                    String content = Files.readString(Path.of(filePath, new String[0]));
                    class_310.method_1551().execute(() -> this.setBookContents(content, withFormatting));
                }
                catch (IOException e) {
                    class_310.method_1551().execute(() -> this.player.method_7353((class_2561)class_2561.method_43471((String)"gui.scholar.import_book.failure"), false));
                    Scholar.LOGGER.error("Failed to import book: ", (Throwable)e);
                }
            });
        }).exceptionally(e -> {
            class_310.method_1551().execute(() -> this.player.method_7353((class_2561)class_2561.method_43471((String)"gui.scholar.import_book.failure"), false));
            Scholar.LOGGER.error("Failed to import book: ", e);
            return null;
        });
    }

    public void exportBook(boolean withFormatting) {
        String content;
        String string = content = withFormatting ? String.join((CharSequence)"\f", this.pages) : class_124.method_539((String)String.join((CharSequence)"\f", this.pages));
        assert (content != null);
        CompletableFuture.runAsync(() -> {
            Object defaultDirectory = class_310.method_1551().field_1697.toPath().toAbsolutePath().normalize().toString();
            if (!((String)defaultDirectory).endsWith(File.separator)) {
                defaultDirectory = (String)defaultDirectory + File.separator;
            }
            String title = class_2561.method_43471((String)"gui.scholar.export_book").getString();
            FileDialogs.saveFile((String)defaultDirectory, title, "Text Files (.txt)", "*.txt").ifPresent(filePath -> {
                try {
                    Files.writeString(Path.of(filePath, new String[0]), (CharSequence)content, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    class_5250 filePathComponent = class_2561.method_43470((String)filePath).method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11746, filePath)));
                    class_310.method_1551().execute(() -> this.player.method_7353((class_2561)class_2561.method_43471((String)"gui.scholar.export_book.success").method_10852((class_2561)filePathComponent), false));
                }
                catch (IOException e) {
                    class_310.method_1551().execute(() -> this.player.method_7353((class_2561)class_2561.method_43471((String)"gui.scholar.export_book.failure"), false));
                    Scholar.LOGGER.error("Failed to export book: ", (Throwable)e);
                }
            });
        }).exceptionally(e -> {
            class_310.method_1551().execute(() -> this.player.method_7353((class_2561)class_2561.method_43471((String)"gui.scholar.export_book.failure"), false));
            Scholar.LOGGER.error("Failed to export book: ", e);
            return null;
        });
    }

    public void method_25419() {
        this.saveChanges(false, null);
        super.method_25419();
    }
}

