/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.widget.textbox;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.scholar.client.gui.widget.textbox.display.FormattedStringDisplayCache;
import io.github.mortuusars.scholar.client.gui.widget.textbox.display.FormattingToolbar;
import io.github.mortuusars.scholar.client.gui.widget.textbox.display.HorizontalAlignment;
import io.github.mortuusars.scholar.client.gui.widget.textbox.display.Line;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedString;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedStringEditor;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.Formatting;
import io.github.mortuusars.scholar.client.util.Pos2i;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_768;
import org.jetbrains.annotations.NotNull;

public class TextBox
extends class_339 {
    protected final class_327 font;
    protected FormattedStringEditor editor = new FormattedStringEditor(() -> FormattedStringEditor.Validator.fitInDimensions(this.getFont(), this.method_25368(), this.method_25364()));
    protected FormattedStringDisplayCache displayCache = new FormattedStringDisplayCache(this.editor);
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    protected int fontColor = -16777216;
    protected int fontUnfocusedColor = -16777216;
    protected int selectionColor = -16776961;
    protected int selectionUnfocusedColor = -2013265665;
    protected Consumer<FormattedString> onTextChanged = text -> {};
    protected FormattingToolbar formattingToolbar = new FormattingToolbar(this);
    protected Pos2i lastClickPos = new Pos2i(0, 0);
    protected long lastActionTime;
    protected boolean canDrag;

    public TextBox(int x, int y, int width, int height) {
        this(class_310.method_1551().field_1772, x, y, width, height);
    }

    public TextBox(class_327 font, int x, int y, int width, int height) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.font = font;
    }

    public class_327 getFont() {
        return this.font;
    }

    public FormattedStringEditor getEditor() {
        return this.editor;
    }

    public FormattedStringDisplayCache getDisplayCache() {
        if (this.displayCache.shouldUpdate()) {
            this.displayCache.update(this.getFont(), this.method_25368(), this.method_25364(), this.getHorizontalAlignment());
        }
        return this.displayCache;
    }

    public FormattingToolbar getFormattingToolbar() {
        if (this.formattingToolbar.shouldUpdate()) {
            this.formattingToolbar.update();
        }
        return this.formattingToolbar;
    }

    public TextBox setFormattingToolbar(FormattingToolbar formattingToolbar) {
        this.formattingToolbar = formattingToolbar;
        this.formattingToolbar.scheduleUpdate();
        return this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public TextBox setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        this.refreshDisplayCache();
        return this;
    }

    public int getFontColor() {
        return this.fontColor;
    }

    public TextBox setFontColor(int fontColor) {
        this.fontColor = fontColor;
        this.refreshDisplayCache();
        return this;
    }

    public int getFontUnfocusedColor() {
        return this.fontUnfocusedColor;
    }

    public TextBox setFontUnfocusedColor(int fontUnfocusedColor) {
        this.fontUnfocusedColor = fontUnfocusedColor;
        this.refreshDisplayCache();
        return this;
    }

    public int getSelectionColor() {
        return this.selectionColor;
    }

    public TextBox setSelectionColor(int selectionColor) {
        this.selectionColor = selectionColor;
        this.refreshDisplayCache();
        return this;
    }

    public int getSelectionUnfocusedColor() {
        return this.selectionUnfocusedColor;
    }

    public TextBox setSelectionUnfocusedColor(int selectionUnfocusedColor) {
        this.selectionUnfocusedColor = selectionUnfocusedColor;
        this.refreshDisplayCache();
        return this;
    }

    public int getCurrentFontColor() {
        return this.method_25370() ? this.fontColor : this.fontUnfocusedColor;
    }

    public int getCurrentSelectionColor() {
        return this.method_25370() ? this.selectionColor : this.selectionUnfocusedColor;
    }

    public TextBox setTextValidator(Predicate<String> validator) {
        this.getEditor().setValidator(validator);
        return this;
    }

    public Consumer<FormattedString> onTextChanged() {
        return this.onTextChanged;
    }

    public TextBox setOnTextChanged(Consumer<FormattedString> onTextChanged) {
        this.onTextChanged = onTextChanged;
        return this;
    }

    public TextBox setText(FormattedString text) {
        this.getEditor().setString(text);
        return this;
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        FormattedStringDisplayCache displayCache = this.getDisplayCache();
        this.renderLines(guiGraphics, mouseX, mouseY, partialTick, displayCache.getLines(), this.getCurrentFontColor());
        int cursorColor = this.getCurrentFontColor();
        Formatting currentFormatting = this.getEditor().getFormattingAtCursor();
        if (currentFormatting.color() != null) {
            cursorColor = currentFormatting.color().asChatFormatting().method_532() | 0xFF000000;
        }
        this.renderCursor(guiGraphics, mouseX, mouseY, partialTick, this.getEditor(), displayCache.getCursor(), cursorColor);
        this.renderSelection(guiGraphics, mouseX, mouseY, partialTick, displayCache.getSelection(), this.getCurrentSelectionColor());
        this.getFormattingToolbar().render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderLines(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, List<Line> lines, int color) {
        for (Line line : lines) {
            guiGraphics.method_51433(this.font, line.renderedString(), this.method_46426() + line.x(), this.method_46427() + line.y(), color, false);
        }
    }

    public void renderSelection(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, List<class_768> selection, int color) {
        for (class_768 rect : selection) {
            int x0 = this.method_46426() + rect.method_3321();
            int y0 = this.method_46427() + rect.method_3322();
            int x1 = x0 + rect.method_3319();
            int y1 = y0 + rect.method_3320();
            guiGraphics.method_51739(class_1921.method_51786(), x0, y0, x1, y1, color);
        }
    }

    public void renderCursor(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, FormattedStringEditor editor, Pos2i cursor, int color) {
        if (!this.method_25370()) {
            return;
        }
        if (editor.isSelecting()) {
            return;
        }
        if (System.currentTimeMillis() - this.lastActionTime > 200L && (System.currentTimeMillis() - this.lastActionTime) % 600L > 300L) {
            return;
        }
        if (editor.isCursorAtEnd()) {
            Line line = this.getDisplayCache().getLine(this.getDisplayCache().getLines().size() - 1);
            int n = cursor.y;
            Objects.requireNonNull(this.font);
            if (n + 9 > this.method_25364()) {
                int x = line.x() + line.width();
                int y = line.y();
                guiGraphics.method_51433(this.getFont(), "<", this.method_46426() + x, this.method_46427() + y, color, false);
            } else {
                guiGraphics.method_51433(this.getFont(), "_", this.method_46426() + cursor.x, this.method_46427() + cursor.y, color, false);
            }
        } else {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 50.0f);
            RenderSystem.disableBlend();
            int n = this.method_46426() + cursor.x;
            int n2 = this.method_46427() + cursor.y - 1;
            int n3 = this.method_46426() + cursor.x + 1;
            int n4 = this.method_46427() + cursor.y;
            Objects.requireNonNull(this.font);
            guiGraphics.method_25294(n, n2, n3, n4 + 9, color);
            guiGraphics.method_51448().method_22909();
        }
    }

    protected void refreshDisplayCache() {
        this.displayCache.scheduleUpdate();
        this.formattingToolbar.scheduleUpdate();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!(this.method_25370() && this.method_37303() && this.field_22764)) {
            return false;
        }
        if (this.handleKeyPressed(keyCode, scanCode, modifiers)) {
            this.lastActionTime = System.currentTimeMillis();
            this.onTextChanged().accept(this.getEditor().getString());
            this.refreshDisplayCache();
            return true;
        }
        return false;
    }

    protected boolean handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.getFormattingToolbar().keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 265) {
            this.changeLine(-1);
            return true;
        }
        if (keyCode == 264) {
            this.changeLine(1);
            return true;
        }
        if (keyCode == 268) {
            this.keyHome();
            return true;
        }
        if (keyCode == 269) {
            this.keyEnd();
            return true;
        }
        return this.getEditor().keyPressed(keyCode);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.method_25370() && this.getEditor().charTyped(codePoint)) {
            this.lastActionTime = System.currentTimeMillis();
            this.onTextChanged().accept(this.getEditor().getString());
            this.refreshDisplayCache();
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_37303() || !this.field_22764) {
            return false;
        }
        if (this.getFormattingToolbar().mouseClicked(mouseX, mouseY, button)) {
            this.refreshDisplayCache();
            this.onTextChanged().accept(this.getEditor().getString());
            this.canDrag = false;
            return true;
        }
        if (this.field_22762 && button == 0) {
            long currentTime = System.currentTimeMillis();
            FormattedStringDisplayCache display = this.getDisplayCache();
            int indexAtMousePos = display.getCharIndexAtPosition(this.font, (int)(mouseX - (double)this.method_46426()), (int)(mouseY - (double)this.method_46427()));
            if (Math.abs(this.lastClickPos.x - (int)mouseX) < 4 && Math.abs(this.lastClickPos.y - (int)mouseY) < 4 && currentTime - this.lastActionTime < 250L) {
                if (!this.getEditor().isSelecting()) {
                    this.getEditor().selectWord(indexAtMousePos);
                } else {
                    this.getEditor().selectAll();
                }
            } else {
                this.getEditor().setCursorPos(indexAtMousePos, class_437.method_25442());
            }
            this.refreshDisplayCache();
            this.lastClickPos = new Pos2i((int)mouseX, (int)mouseY);
            this.lastActionTime = currentTime;
            this.canDrag = true;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.canDrag) {
            FormattedStringDisplayCache display = this.getDisplayCache();
            int indexAtMousePos = display.getCharIndexAtPosition(this.font, (int)(mouseX - (double)this.method_46426()), (int)(mouseY - (double)this.method_46427()));
            this.getEditor().setCursorPos(indexAtMousePos, true);
            this.refreshDisplayCache();
            return true;
        }
        return false;
    }

    public void changeLine(int yChange) {
        Pos2i cursor = this.getDisplayCache().getCursor();
        int x = cursor.x;
        int n = cursor.y;
        Objects.requireNonNull(this.font);
        int y = n + 9 * yChange;
        int index = this.getDisplayCache().getCharIndexAtPosition(this.font, x, y);
        this.getEditor().setCursorPos(index, class_437.method_25442());
    }

    public void keyHome() {
        if (class_437.method_25441()) {
            this.getEditor().setCursorToStart(class_437.method_25442());
        } else {
            int cursorPos = this.getEditor().getCursorPos();
            int lineIndex = this.getDisplayCache().findLineIndexByCharIndex(cursorPos);
            Line line = this.getDisplayCache().getLine(lineIndex);
            this.getEditor().setCursorPos(line.firstCharIndex(), class_437.method_25442());
        }
    }

    public void keyEnd() {
        if (class_437.method_25441()) {
            this.getEditor().setCursorToEnd(class_437.method_25442());
        } else {
            int cursorPos = this.getEditor().getCursorPos();
            int lineIndex = this.getDisplayCache().findLineIndexByCharIndex(cursorPos);
            Line line = this.getDisplayCache().getLine(lineIndex);
            this.getEditor().setCursorPos(line.lastCharIndex() + 1, class_437.method_25442());
        }
    }

    @NotNull
    public class_2561 method_25369() {
        return class_2561.method_43470((String)this.getEditor().getString().toStringWithoutFormatting());
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
    }
}

