/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.widget.textbox.text;

import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.Char;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedString;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.Formatting;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5225;
import org.jetbrains.annotations.Nullable;

public class FormattedStringEditor {
    protected FormattedString string = new FormattedString();
    protected int cursorPos;
    protected int selectionAnchor;
    protected Predicate<String> validator;
    private boolean suppressNextCharTyped = false;

    public FormattedStringEditor(Predicate<String> validator) {
        this.validator = validator;
    }

    public FormattedStringEditor(Supplier<Predicate<String>> stringValidator) {
        this.validator = str -> ((Predicate)stringValidator.get()).test(str);
    }

    public FormattedString getString() {
        return this.string;
    }

    public void setString(FormattedString string) {
        this.string = string;
    }

    public int getCursorPos() {
        return this.cursorPos;
    }

    public int getSelectionAnchor() {
        return this.selectionAnchor;
    }

    public Predicate<String> getValidator() {
        return this.validator;
    }

    public void setValidator(Predicate<String> validator) {
        this.validator = validator;
    }

    public int length() {
        return this.getString().size();
    }

    public List<Char> getSpan(int start, int end) {
        return this.getString().subList(start, end);
    }

    public List<Char> getSelectedSpan() {
        return this.getSpan(this.getSelectionStart(), this.getSelectionEnd());
    }

    public boolean isCursorAtStart() {
        return this.getCursorPos() == 0;
    }

    public boolean isCursorAtEnd() {
        return this.getCursorPos() == this.length();
    }

    public void setCursorPos(int index) {
        this.setCursorPos(index, true);
    }

    public void setCursorPos(int index, boolean keepSelection) {
        this.cursorPos = this.clampIndex(index);
        this.resetSelectionIfNeeded(keepSelection);
    }

    public void setCursorToStart(boolean keepSelection) {
        this.setCursorPos(0, keepSelection);
    }

    public void setCursorToEnd(boolean keepSelection) {
        this.setCursorPos(this.length(), keepSelection);
    }

    public void moveCursorBy(int direction, boolean keepSelection, CursorStep cursorStep) {
        switch (cursorStep.ordinal()) {
            case 0: {
                this.moveCursorByChars(direction, keepSelection);
                break;
            }
            case 1: {
                this.moveCursorByWords(direction, keepSelection);
            }
        }
    }

    public void moveCursorByChars(int direction, boolean keepSelection) {
        if (!keepSelection && this.isSelecting()) {
            this.setCursorPos(direction < 0 ? this.getSelectionStart() : this.getSelectionEnd(), false);
        } else {
            this.setCursorPos(class_156.method_27761((String)this.getString().toStringWithoutFormatting(), (int)this.getCursorPos(), (int)direction), keepSelection);
        }
    }

    public void moveCursorByWords(int direction, boolean keepSelection) {
        if (!keepSelection && this.isSelecting()) {
            this.setCursorPos(direction < 0 ? this.getSelectionStart() : this.getSelectionEnd(), false);
        } else {
            this.setCursorPos(class_5225.method_27483((String)this.getString().toStringWithoutFormatting(), (int)direction, (int)this.getCursorPos(), (boolean)true), keepSelection);
        }
    }

    public Formatting getFormattingAtCursor() {
        int charBeforeCursor = this.getCursorPos() - 1;
        if (charBeforeCursor >= 0 && charBeforeCursor < this.length()) {
            return ((Char)this.getString().get(charBeforeCursor)).formatting();
        }
        return Formatting.EMPTY;
    }

    public boolean isSelecting() {
        return this.getCursorPos() != this.getSelectionAnchor();
    }

    public int getSelectionStart() {
        return Math.min(this.getCursorPos(), this.getSelectionAnchor());
    }

    public int getSelectionEnd() {
        return Math.max(this.getCursorPos(), this.getSelectionAnchor());
    }

    public void setSelectionAnchor(int index) {
        this.selectionAnchor = this.clampIndex(index);
    }

    public void setSelectionRange(int start, int end) {
        this.setSelectionAnchor(start);
        this.setCursorPos(end, true);
    }

    public void selectWord(int index) {
        this.setSelectionRange(class_5225.method_27483((String)this.getString().toStringWithoutFormatting(), (int)-1, (int)index, (boolean)false), class_5225.method_27483((String)this.getString().toStringWithoutFormatting(), (int)1, (int)index, (boolean)false));
    }

    public String getSelectedString(boolean withFormatting) {
        if (!this.isSelecting()) {
            return "";
        }
        FormattedString selectedString = this.getString().subString(this.getSelectionStart(), this.getSelectionEnd());
        return withFormatting ? selectedString.toString() : selectedString.toStringWithoutFormatting();
    }

    public boolean keyPressed(int key) {
        if (this.onKeyPressed(key)) {
            this.suppressNextCharTyped = true;
            return true;
        }
        this.suppressNextCharTyped = false;
        return false;
    }

    private boolean onKeyPressed(int key) {
        CursorStep cursorStep;
        if (class_437.method_25439((int)key)) {
            this.selectAll();
            return true;
        }
        if (key == 67 && class_437.method_25441() && !class_437.method_25443()) {
            this.copy(class_437.method_25442());
            return true;
        }
        if (key == 86 && class_437.method_25441() && !class_437.method_25443()) {
            this.paste(class_437.method_25442());
            return true;
        }
        if (key == 88 && class_437.method_25441() && !class_437.method_25443()) {
            this.cut(class_437.method_25442());
            return true;
        }
        CursorStep cursorStep2 = cursorStep = class_437.method_25441() ? CursorStep.WORD : CursorStep.CHARACTER;
        if (key == 259) {
            this.removeFromCursor(-1, cursorStep);
            return true;
        }
        if (key == 261) {
            this.removeFromCursor(1, cursorStep);
            return true;
        }
        if (key == 263) {
            this.moveCursorBy(-1, class_437.method_25442(), cursorStep);
            return true;
        }
        if (key == 262) {
            this.moveCursorBy(1, class_437.method_25442(), cursorStep);
            return true;
        }
        if (key == 268) {
            this.setCursorToStart(class_437.method_25442());
            return true;
        }
        if (key == 269) {
            this.setCursorToEnd(class_437.method_25442());
            return true;
        }
        if (key == 257 || key == 335) {
            this.insertTextAtCursor("\n");
            return true;
        }
        @Nullable Formatting formatting = this.handleFormattingKeys(key);
        if (formatting != null) {
            this.applyFormatting(formatting);
            return true;
        }
        return false;
    }

    protected Formatting handleFormattingKeys(int key) {
        if (class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443()) {
            return switch (key) {
                case 49 -> Formatting.of(Formatting.Color.BLACK);
                case 50 -> Formatting.of(Formatting.Color.DARK_BLUE);
                case 51 -> Formatting.of(Formatting.Color.DARK_GREEN);
                case 52 -> Formatting.of(Formatting.Color.DARK_AQUA);
                case 53 -> Formatting.of(Formatting.Color.DARK_RED);
                case 54 -> Formatting.of(Formatting.Color.DARK_PURPLE);
                case 55 -> Formatting.of(Formatting.Color.GOLD);
                case 56 -> Formatting.of(Formatting.Color.GRAY);
                case 75 -> Formatting.of(Formatting.Format.OBFUSCATED);
                case 76 -> Formatting.of(Formatting.Format.BOLD);
                case 77 -> Formatting.of(Formatting.Format.STRIKETHROUGH);
                case 78 -> Formatting.of(Formatting.Format.UNDERLINE);
                case 79 -> Formatting.of(Formatting.Format.ITALIC);
                case 82 -> Formatting.EMPTY;
                default -> null;
            };
        }
        if (class_437.method_25441() && class_437.method_25442() && !class_437.method_25443()) {
            return switch (key) {
                case 49 -> Formatting.of(Formatting.Color.DARK_GRAY);
                case 50 -> Formatting.of(Formatting.Color.BLUE);
                case 51 -> Formatting.of(Formatting.Color.GREEN);
                case 52 -> Formatting.of(Formatting.Color.AQUA);
                case 53 -> Formatting.of(Formatting.Color.RED);
                case 54 -> Formatting.of(Formatting.Color.LIGHT_PURPLE);
                case 55 -> Formatting.of(Formatting.Color.YELLOW);
                case 56 -> Formatting.of(Formatting.Color.WHITE);
                default -> null;
            };
        }
        return null;
    }

    public void applyFormatting(Formatting formatting) {
        if (formatting.format().contains(Formatting.Format.BOLD)) {
            FormattedString string = new FormattedString((Collection<? extends Char>)this.getString().stream().map(c -> new Char(c.character(), c.formatting().copy())).toList());
            List chars = string.subList(this.getSelectionStart(), this.getSelectionEnd());
            chars.replaceAll(c -> c.flipFormatting(formatting));
            if (!this.validator.test(string.toString())) {
                return;
            }
        }
        if (this.isSelecting()) {
            this.getSelectedSpan().replaceAll(c -> c.flipFormatting(formatting));
        } else if (formatting == Formatting.EMPTY) {
            this.getString().replaceAll(c -> c.withFormatting(Formatting.EMPTY));
        }
    }

    public boolean charTyped(char character) {
        return !this.suppressNextCharTyped && class_155.method_643((char)character) && this.insertTextAtCursor(Character.toString(character));
    }

    public void cut(boolean withFormatting) {
        this.copy(withFormatting);
        this.removeSelectedText();
    }

    public void paste(boolean keepFormatting) {
        try {
            String text = class_310.method_1551().field_1774.method_1460();
            if (!keepFormatting) {
                text = class_124.method_539((String)text);
            }
            this.insertTextAtCursor(Objects.requireNonNull(text).replaceAll("\\r", ""));
        }
        catch (Exception e) {
            Scholar.LOGGER.error("Text Paste error: ", (Throwable)e);
        }
    }

    public void copy(boolean withFormatting) {
        class_310.method_1551().field_1774.method_1455(this.getSelectedString(withFormatting));
    }

    public void selectAll() {
        this.setSelectionAnchor(0);
        this.setCursorPos(this.length(), true);
    }

    public boolean insertTextAtCursor(String text) {
        if (this.isSelecting()) {
            this.removeSelectedText();
        }
        FormattedString insertedString = FormattedString.parse(text);
        insertedString.replaceAll(c -> {
            if (!c.hasFormatting()) {
                return c.withFormatting(this.getFormattingAtCursor());
            }
            return c;
        });
        FormattedString newString = new FormattedString(this.getString());
        newString.addAll(this.getCursorPos(), insertedString);
        String string = newString.toStringWithoutFormatting();
        if (this.validator.test(string)) {
            this.string = newString;
            this.setCursorPos(this.getCursorPos() + insertedString.length(), false);
            return true;
        }
        return false;
    }

    public void removeFromCursor(int direction, CursorStep step) {
        switch (step.ordinal()) {
            case 0: {
                this.removeCharsFromCursor(direction);
                break;
            }
            case 1: {
                this.removeWordsFromCursor(direction);
            }
        }
    }

    public void removeWordsFromCursor(int direction) {
        int charsCount = class_5225.method_27483((String)this.getString().toStringWithoutFormatting(), (int)direction, (int)this.cursorPos, (boolean)true);
        this.removeCharsFromCursor(charsCount - this.cursorPos);
    }

    public void removeCharsFromCursor(int direction) {
        String string = this.getString().toStringWithoutFormatting();
        if (!string.isEmpty()) {
            if (this.isSelecting()) {
                this.removeSelectedText();
            } else {
                int cursor = this.getCursorPos();
                int removePos = class_156.method_27761((String)string, (int)cursor, (int)direction);
                int start = Math.min(removePos, cursor);
                int end = Math.max(removePos, cursor);
                this.getSpan(start, end).clear();
                this.setCursorPos(start, false);
            }
        }
    }

    public void removeSelectedText() {
        if (!this.isSelecting()) {
            return;
        }
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        this.getSpan(start, end).clear();
        this.setCursorPos(start, false);
    }

    protected void resetSelectionIfNeeded(boolean keepSelection) {
        if (!keepSelection) {
            this.setSelectionAnchor(this.getCursorPos());
        }
    }

    protected int clampIndex(int index) {
        return class_3532.method_15340((int)index, (int)0, (int)this.length());
    }

    public static enum CursorStep {
        CHARACTER,
        WORD;

    }

    public static interface Validator {
        public static Predicate<String> fitInDimensions(class_327 font, int width, int height) {
            return string -> {
                int n;
                if (string.length() >= 1024) return false;
                int n2 = font.method_1713(string, width);
                if (string.endsWith("\n")) {
                    Objects.requireNonNull(font);
                    n = 9;
                } else {
                    n = 0;
                }
                if (n2 + n > height) return false;
                return true;
            };
        }
    }
}

