/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.network.packet.server;

import com.google.common.collect.Lists;
import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.network.PacketDirection;
import io.github.mortuusars.scholar.network.packet.IPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3722;
import net.minecraft.class_5513;
import net.minecraft.class_5837;
import org.jetbrains.annotations.Nullable;

public record LecternEditBookC2SP(class_2338 lecternPos, List<String> pages, Optional<String> title) implements IPacket
{
    public static final class_2960 ID = Scholar.resource("lectern_edit_book");
    private static final int TITLE_MAX_CHARS = 128;
    private static final int PAGE_MAX_CHARS = 8192;
    private static final int MAX_PAGES_COUNT = 200;

    @Override
    public class_2960 getId() {
        return ID;
    }

    public static LecternEditBookC2SP fromBuffer(class_2540 buffer) {
        return new LecternEditBookC2SP(buffer.method_10811(), (List)buffer.method_34068(class_2540.method_37453(Lists::newArrayListWithCapacity, (int)200), friendlyByteBuf -> friendlyByteBuf.method_10800(8192)), buffer.method_37436(friendlyByteBuf -> friendlyByteBuf.method_10800(128)));
    }

    @Override
    public class_2540 toBuffer(class_2540 buffer) {
        buffer.method_10807(this.lecternPos);
        buffer.method_34062(this.pages, (friendlyByteBuf, string) -> friendlyByteBuf.method_10788(string, 8192));
        buffer.method_37435(this.title, (friendlyByteBuf, string) -> friendlyByteBuf.method_10788(string, 128));
        return buffer;
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable class_1657 player) {
        if (!(player instanceof class_3222)) {
            Scholar.LOGGER.error("Cannot handle {} packet: player is not ServerPlayer.", (Object)this.getId());
            return true;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_2586 class_25862 = player.method_37908().method_8321(this.lecternPos);
        if (!(class_25862 instanceof class_3722)) {
            Scholar.LOGGER.error("Cannot update lectern book: no lectern block entity at lecternPos '{}'", (Object)this.lecternPos);
            return false;
        }
        class_3722 lecternBlockEntity = (class_3722)class_25862;
        ArrayList<String> bookPages = new ArrayList<String>();
        Optional<String> title = this.title();
        title.ifPresent(bookPages::add);
        this.pages().stream().limit(100L).forEach(bookPages::add);
        Consumer<List> consumer = title.isPresent() ? list -> this.signBook(serverPlayer, (class_5837)list.get(0), list.subList(1, list.size()), lecternBlockEntity) : list -> this.updateBookContents(serverPlayer, (List<class_5837>)list, lecternBlockEntity);
        this.filterTextPacket(serverPlayer, bookPages).thenAccept(consumer);
        return true;
    }

    private void updateBookContents(class_3222 player, List<class_5837> pages, class_3722 lecternBlockEntity) {
        class_1799 itemStack = lecternBlockEntity.method_17520();
        if (!itemStack.method_31574(class_1802.field_8674)) {
            return;
        }
        this.updateBookPages(player, pages, UnaryOperator.identity(), itemStack, lecternBlockEntity);
    }

    private void signBook(class_3222 player, class_5837 title, List<class_5837> pages, class_3722 lecternBlockEntity) {
        class_1799 itemStack = lecternBlockEntity.method_17520();
        if (!itemStack.method_31574(class_1802.field_8674)) {
            return;
        }
        class_1799 writtenBookStack = new class_1799((class_1935)class_1802.field_8360);
        class_2487 compoundTag = itemStack.method_7969();
        if (compoundTag != null) {
            writtenBookStack.method_7980(compoundTag.method_10553());
        }
        writtenBookStack.method_7959("author", (class_2520)class_2519.method_23256((String)player.method_5477().getString()));
        if (player.method_33793()) {
            writtenBookStack.method_7959("title", (class_2520)class_2519.method_23256((String)title.method_45061()));
        } else {
            writtenBookStack.method_7959("filtered_title", (class_2520)class_2519.method_23256((String)title.method_45061()));
            writtenBookStack.method_7959("title", (class_2520)class_2519.method_23256((String)title.comp_841()));
        }
        this.updateBookPages(player, pages, string -> class_2561.class_2562.method_10867((class_2561)class_2561.method_43470((String)string)), writtenBookStack, lecternBlockEntity);
        lecternBlockEntity.method_17514(writtenBookStack, (class_1657)player);
    }

    private void updateBookPages(class_3222 player, List<class_5837> pages, UnaryOperator<String> updater, class_1799 book, class_3722 lecternBlockEntity) {
        class_2499 listTag = new class_2499();
        if (player.method_33793()) {
            pages.stream().map(filteredText -> class_2519.method_23256((String)((String)updater.apply(filteredText.method_45061())))).forEach(arg_0 -> listTag.add(arg_0));
        } else {
            class_2487 compoundTag = new class_2487();
            int j = pages.size();
            for (int i = 0; i < j; ++i) {
                class_5837 filteredText2 = pages.get(i);
                String string = filteredText2.comp_841();
                listTag.add((Object)class_2519.method_23256((String)((String)updater.apply(string))));
                if (!filteredText2.method_45063()) continue;
                compoundTag.method_10582(String.valueOf(i), (String)updater.apply(filteredText2.method_45061()));
            }
            if (!compoundTag.method_33133()) {
                book.method_7959("filtered_pages", (class_2520)compoundTag);
            }
        }
        book.method_7959("pages", (class_2520)listTag);
    }

    private <T, R> CompletableFuture<R> filterTextPacket(class_3222 player, T message, BiFunction<class_5513, T, CompletableFuture<R>> processor) {
        return processor.apply(player.method_31273(), (class_5513)message).thenApply(object -> {
            if (!player.field_13987.method_48106()) {
                Scholar.LOGGER.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private CompletableFuture<List<class_5837>> filterTextPacket(class_3222 player, List<String> texts) {
        return this.filterTextPacket(player, texts, class_5513::method_31289);
    }
}

