/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.render;

import io.github.mortuusars.scholar.Config;
import io.github.mortuusars.scholar.book.BookColor;
import io.github.mortuusars.scholar.integration.Mods;
import io.github.mortuusars.scholar.integration.mcbv.MoreChiseledBookshelfVariantsIntegration;
import io.github.mortuusars.scholar.integration.woodster.WoodsterIntegration;
import io.github.mortuusars.scholar.integration.woodworks.WoodworksIntegration;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import net.minecraft.class_1799;
import net.minecraft.class_1840;
import net.minecraft.class_1843;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_7714;
import net.minecraft.class_7716;
import net.minecraft.class_7923;
import net.minecraft.class_8002;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;

public class ChiseledBookShelf {
    public static final int DEFAULT_TINT_SLOT_0 = -15025988;
    public static final int DEFAULT_TINT_SLOT_1 = -8867520;
    public static final int DEFAULT_TINT_SLOT_2 = -5815323;
    public static final int DEFAULT_TINT_SLOT_3 = -2864530;
    public static final int DEFAULT_TINT_SLOT_4 = -2787242;
    public static final int DEFAULT_TINT_SLOT_5 = -13669434;
    public static final Map<class_2960, Integer> CUSTOM_COLORS = new HashMap<class_2960, Integer>();

    public static int getSlotTintColor(class_2680 state, @Nullable class_1920 blockGetter, @Nullable class_2338 pos, int tintIndex) {
        class_2586 class_25862;
        if (!((Boolean)Config.Common.CHISELED_BOOKSHELF_COLORS.get()).booleanValue()) {
            return ChiseledBookShelf.getDefaultTintColorForSlot(state, tintIndex);
        }
        if (blockGetter == null || pos == null || tintIndex < 0 || tintIndex > 5 || !((class_25862 = blockGetter.method_8321(pos)) instanceof class_7716)) {
            return ChiseledBookShelf.getDefaultTintColorForSlot(state, tintIndex);
        }
        class_7716 blockEntity = (class_7716)class_25862;
        class_1799 stackInSlot = blockEntity.method_5438(tintIndex);
        if (stackInSlot.method_7960()) {
            return -1;
        }
        if (stackInSlot.method_7909() instanceof class_1843 || stackInSlot.method_7909() instanceof class_1840) {
            return BookColor.of(stackInSlot);
        }
        return CUSTOM_COLORS.getOrDefault(class_7923.field_41178.method_10221((Object)stackInSlot.method_7909()), ChiseledBookShelf.getDefaultTintColorForSlot(state, tintIndex));
    }

    public static int getDefaultTintColorForSlot(class_2680 state, int slot) {
        OptionalInt color;
        if (Mods.WOODWORKS.isLoaded() && (color = WoodworksIntegration.getDefaultTintColor(state, slot)).isPresent()) {
            return color.getAsInt();
        }
        if (Mods.WOODSTER.isLoaded() && (color = WoodsterIntegration.getDefaultTintColor(state, slot)).isPresent()) {
            return color.getAsInt();
        }
        return switch (slot) {
            case 1 -> -8867520;
            case 2 -> -5815323;
            case 3 -> -2864530;
            case 4 -> -2787242;
            case 5 -> -13669434;
            default -> -15025988;
        };
    }

    public static void renderSlotTooltip(class_332 guiGraphics, class_9779 deltaTracker) {
        class_239 class_2392;
        if (!((Boolean)Config.Common.CHISELED_BOOKSHELF_TOOLTIP.get()).booleanValue()) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null || minecraft.field_1724 == null || minecraft.field_1755 != null || !((class_2392 = minecraft.field_1765) instanceof class_3965)) {
            return;
        }
        class_3965 blockHitResult = (class_3965)class_2392;
        class_2338 hitPos = blockHitResult.method_17777();
        class_2680 blockState = minecraft.field_1687.method_8320(hitPos);
        class_2248 class_22482 = blockState.method_26204();
        if (!(class_22482 instanceof class_7714)) {
            return;
        }
        class_7714 chiseledBookShelfBlock = (class_7714)class_22482;
        @Nullable class_2586 blockEntity = minecraft.field_1687.method_8321(hitPos);
        if (!(blockEntity instanceof class_7716)) {
            return;
        }
        class_7716 chiseledBookShelfBlockEntity = (class_7716)blockEntity;
        OptionalInt hitSlot = chiseledBookShelfBlock.method_47580(blockHitResult, blockState);
        if (hitSlot.isEmpty()) {
            return;
        }
        class_1799 bookStack = chiseledBookShelfBlockEntity.method_5438(hitSlot.getAsInt());
        if (bookStack.method_7960()) {
            return;
        }
        int x = minecraft.method_22683().method_4486() / 2 + 16;
        int y = minecraft.method_22683().method_4502() / 2 - 9;
        class_8002.method_47946((class_332)guiGraphics, (int)x, (int)y, (int)18, (int)18, (int)400);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        guiGraphics.method_51427(bookStack, x + 1, y + 1);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51446(minecraft.field_1772, bookStack, x + 16, y + 12);
    }

    public static void registerBookshelfBlockColors(BiConsumer<class_322, class_2248> consumer) {
        consumer.accept(ChiseledBookShelf::getSlotTintColor, class_2246.field_40276);
        if (Mods.MCBV.isLoading()) {
            MoreChiseledBookshelfVariantsIntegration.registerBlockColors(consumer);
        }
        if (Mods.WOODWORKS.isLoading()) {
            WoodworksIntegration.registerBlockColors(consumer);
        }
        if (Mods.WOODSTER.isLoading()) {
            WoodsterIntegration.registerBlockColors(consumer);
        }
    }

    public static void setBookshelfRenderLayer(BiConsumer<class_2248, class_1921> consumer) {
        consumer.accept(class_2246.field_40276, class_1921.method_23581());
        if (Mods.MCBV.isLoading()) {
            MoreChiseledBookshelfVariantsIntegration.setRenderLayer(consumer);
        }
        if (Mods.WOODWORKS.isLoading()) {
            WoodworksIntegration.setRenderLayer(consumer);
        }
        if (Mods.WOODSTER.isLoading()) {
            WoodsterIntegration.setRenderLayer(consumer);
        }
    }

    static {
        CUSTOM_COLORS.put(class_2960.method_60654((String)"minecraft:book"), -6523330);
        CUSTOM_COLORS.put(class_2960.method_60654((String)"exposure:album"), -6013396);
        CUSTOM_COLORS.put(class_2960.method_60654((String)"exposure:signed_album"), -6013396);
    }
}

