/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.util;

import io.github.mortuusars.scholar.Scholar;
import java.util.Optional;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class FileDialogs {
    public static Optional<String> loadFile(String defaultPath, String title, String filterDescription, boolean canChooseMultiple, String ... filters) {
        Optional<String> optional;
        block8: {
            defaultPath = defaultPath.replaceAll("\\\\.$", "\\\\");
            MemoryStack stack = MemoryStack.stackPush();
            try {
                optional = Optional.ofNullable(TinyFileDialogs.tinyfd_openFileDialog((CharSequence)title, (CharSequence)defaultPath, (PointerBuffer)FileDialogs.createFiltersBuffer(filters, stack), (CharSequence)filterDescription, (boolean)canChooseMultiple));
                if (stack == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stack != null) {
                        try {
                            stack.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Scholar.LOGGER.error("Cannot choose file to load: ", (Throwable)e);
                    return Optional.empty();
                }
            }
            stack.close();
        }
        return optional;
    }

    public static Optional<String> saveFile(String defaultPath, String title, String filterDescription, String ... filters) {
        Optional<String> optional;
        block8: {
            defaultPath = defaultPath.replaceAll("\\\\.$", "\\\\");
            MemoryStack stack = MemoryStack.stackPush();
            try {
                optional = Optional.ofNullable(TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)title, (CharSequence)defaultPath, (PointerBuffer)FileDialogs.createFiltersBuffer(filters, stack), (CharSequence)filterDescription));
                if (stack == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stack != null) {
                        try {
                            stack.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Scholar.LOGGER.error("Cannot choose file to load: ", (Throwable)e);
                    return Optional.empty();
                }
            }
            stack.close();
        }
        return optional;
    }

    @Nullable
    private static PointerBuffer createFiltersBuffer(String[] filters, MemoryStack stack) {
        if (class_310.field_1703 || filters.length == 0) {
            return null;
        }
        PointerBuffer filtersBuffer = stack.mallocPointer(filters.length);
        for (String filter : filters) {
            filtersBuffer.put(stack.UTF8((CharSequence)filter));
        }
        filtersBuffer.flip();
        return filtersBuffer;
    }
}

