/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.screen.view;

import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.scholar.client.gui.screen.SpreadBookScreen;
import io.github.mortuusars.scholar.client.gui.screen.view.BookViewAccess;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpreadBookViewScreen
extends SpreadBookScreen {
    protected BookViewAccess bookAccess;
    protected Pair<List<FormattedCharSequence>, List<FormattedCharSequence>> cachedPageComponents;
    protected int cachedSpread;

    public SpreadBookViewScreen(BookViewAccess bookAccess, int bookColor) {
        super(bookColor);
        this.bookAccess = bookAccess;
        this.cachedPageComponents = Pair.of(Collections.emptyList(), Collections.emptyList());
        this.cachedSpread = -1;
    }

    public BookViewAccess getBookAccess() {
        return this.bookAccess;
    }

    public void setBookAccess(BookViewAccess bookViewAccess) {
        this.bookAccess = bookViewAccess;
        this.currentSpread = Mth.clamp((int)this.currentSpread, (int)0, (int)this.getSpreadCount());
        this.cachedSpread = -1;
    }

    @Override
    public int getPageCount() {
        return this.getBookAccess().getPageCount();
    }

    public boolean setPage(int pageIndex) {
        int spreadIndex = (int)((float)(pageIndex = Mth.clamp((int)pageIndex, (int)0, (int)(this.getBookAccess().getPageCount() - 1))) / 2.0f);
        if (spreadIndex != this.currentSpread) {
            this.currentSpread = spreadIndex;
            this.cachedSpread = -1;
            return true;
        }
        return false;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateButtonVisibility();
        this.renderTransparentBackground(guiGraphics);
        this.renderBook(guiGraphics, mouseX, mouseY, partialTick);
        this.renderPageNumbers(guiGraphics, mouseX, mouseY, partialTick, this.currentSpread);
        this.renderTools(guiGraphics, mouseX, mouseY, partialTick);
        this.updateAndCacheContentsIfNeeded();
        this.renderPageContents(guiGraphics, (List)this.cachedPageComponents.getFirst(), this.leftPos + 22, this.topPos + 21);
        this.renderPageContents(guiGraphics, (List)this.cachedPageComponents.getSecond(), this.leftPos + 159, this.topPos + 21);
        Style style = this.getClickedComponentStyleAt(mouseX, mouseY);
        if (style != null) {
            guiGraphics.renderComponentHoverEffect(this.font, style, mouseX, mouseY);
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void updateAndCacheContentsIfNeeded() {
        if (this.cachedSpread != this.currentSpread) {
            FormattedText leftFormattedText = this.getBookAccess().getPage(this.currentSpread * 2);
            FormattedText rightFormattedText = this.getBookAccess().getPageCount() > this.currentSpread * 2 + 1 ? this.getBookAccess().getPage(this.currentSpread * 2 + 1) : FormattedText.EMPTY;
            this.cachedPageComponents = Pair.of((Object)this.font.split(leftFormattedText, 114), (Object)this.font.split(rightFormattedText, 114));
            this.cachedSpread = this.currentSpread;
        }
    }

    protected void renderPageContents(GuiGraphics guiGraphics, List<FormattedCharSequence> lines, int x, int y) {
        Objects.requireNonNull(this.font);
        int maxLines = Math.min(128 / 9, lines.size());
        for (int i = 0; i < maxLines; ++i) {
            FormattedCharSequence text = lines.get(i);
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, text, x, y + i * 9, this.textColor, false);
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        Style style;
        if (button == 0 && (style = this.getClickedComponentStyleAt(x, y)) != null && this.handleComponentClicked(style)) {
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    public boolean handleComponentClicked(Style style) {
        if (style == null) {
            return false;
        }
        ClickEvent clickEvent = style.getClickEvent();
        if (clickEvent == null) {
            return false;
        }
        if (clickEvent.getAction() == ClickEvent.Action.CHANGE_PAGE) {
            String pageNumber = clickEvent.getValue();
            try {
                int pageIndex = Integer.parseInt(pageNumber) - 1;
                boolean pageChanged = this.setPage(pageIndex);
                if (pageChanged) {
                    this.playPageTurnSound();
                }
                return pageChanged;
            }
            catch (Exception var5) {
                return false;
            }
        }
        boolean handled = super.handleComponentClicked(style);
        if (handled && clickEvent.getAction() == ClickEvent.Action.RUN_COMMAND) {
            this.onClose();
        }
        return handled;
    }

    @Nullable
    public Style getClickedComponentStyleAt(double mouseX, double mouseY) {
        List pageContents;
        boolean isOverRightPage;
        if (mouseY < (double)(this.topPos + 21) || mouseY >= (double)(this.topPos + 21 + 128)) {
            return null;
        }
        if (mouseX >= (double)(this.leftPos + 159) && mouseX < (double)(this.leftPos + 159 + 114)) {
            isOverRightPage = true;
        } else if (mouseX >= (double)(this.leftPos + 22) && mouseX < (double)(this.leftPos + 22 + 114)) {
            isOverRightPage = false;
        } else {
            return null;
        }
        List list = pageContents = isOverRightPage ? (List)this.cachedPageComponents.getSecond() : (List)this.cachedPageComponents.getFirst();
        if (pageContents.isEmpty()) {
            return null;
        }
        int x = (int)mouseX - (this.leftPos + (isOverRightPage ? 159 : 22));
        int y = (int)mouseY - (this.topPos + 21);
        Objects.requireNonNull(this.font);
        int linesCount = Math.min(128 / 9, pageContents.size());
        Objects.requireNonNull(this.font);
        if (y < 9 * linesCount + linesCount) {
            Objects.requireNonNull(this.font);
            int clickedLine = y / 9;
            if (clickedLine >= 0 && clickedLine < pageContents.size()) {
                FormattedCharSequence text = (FormattedCharSequence)pageContents.get(clickedLine);
                return this.font.getSplitter().componentStyleAtWidth(text, x);
            }
            return null;
        }
        return null;
    }
}

