/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.widget.textbox.text;

import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Formatting(@Nullable Color color, EnumSet<Format> format) {
    public static final char SECTION_SIGN = '\u00a7';
    public static final Reset RESET = new Reset();
    public static final Formatting EMPTY = new Formatting(null, EnumSet.noneOf(Format.class));

    public static Formatting of(Color color) {
        return new Formatting(color, EnumSet.noneOf(Format.class));
    }

    public static Formatting of(Format format) {
        return new Formatting(null, EnumSet.of(format));
    }

    public static Formatting of(char code) {
        return EMPTY.with(code);
    }

    public static Formatting of(ChatFormatting formatting) {
        return Formatting.of(formatting.getChar());
    }

    public static Formatting of(Type type) {
        return Formatting.of(type.getChar());
    }

    public boolean isEmpty() {
        return this.color == null && this.format.isEmpty();
    }

    public Formatting with(Color color) {
        return new Formatting(color, EnumSet.copyOf(this.format));
    }

    public Formatting with(Format format) {
        EnumSet<Format> formats = EnumSet.copyOf(this.format);
        formats.add(format);
        return new Formatting(this.color, formats);
    }

    public Formatting with(char code) {
        if (code == RESET.getChar()) {
            return EMPTY;
        }
        @Nullable Color color = Color.fromChar(code);
        if (color != null) {
            return this.with(color);
        }
        @Nullable Format format = Format.fromChar(code);
        if (format != null) {
            return this.with(format);
        }
        return this;
    }

    public StringBuilder append(StringBuilder sb) {
        if (this.color != null) {
            sb.append('\u00a7').append(this.color.getChar());
        }
        for (Format format : this.format) {
            sb.append('\u00a7').append(format.getChar());
        }
        return sb;
    }

    public Formatting flip(Formatting formatting) {
        if (formatting.isEmpty()) {
            return EMPTY;
        }
        @Nullable Color color = this.color();
        EnumSet<Format> format = EnumSet.copyOf(this.format());
        if (formatting.color() != null) {
            color = formatting.color() != color ? formatting.color() : null;
        }
        for (Format f : formatting.format()) {
            if (format.contains(f)) {
                format.remove(f);
                continue;
            }
            format.add(f);
        }
        return new Formatting(color, format);
    }

    public Formatting copy() {
        return new Formatting(this.color, EnumSet.copyOf(this.format));
    }

    public static enum Color implements Type
    {
        BLACK("black", '0'),
        DARK_BLUE("dark_blue", '1'),
        DARK_GREEN("dark_green", '2'),
        DARK_AQUA("dark_aqua", '3'),
        DARK_RED("dark_red", '4'),
        DARK_PURPLE("dark_purple", '5'),
        GOLD("gold", '6'),
        GRAY("gray", '7'),
        DARK_GRAY("dark_gray", '8'),
        BLUE("blue", '9'),
        GREEN("green", 'a'),
        AQUA("aqua", 'b'),
        RED("red", 'c'),
        LIGHT_PURPLE("light_purple", 'd'),
        YELLOW("yellow", 'e'),
        WHITE("white", 'f');

        private final String name;
        private final char c;

        private Color(String name, char c) {
            this.name = name;
            this.c = c;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public char getChar() {
            return this.c;
        }

        @Nullable
        public static Color fromChar(char c) {
            for (Color value : Color.values()) {
                if (value.c != c) continue;
                return value;
            }
            return null;
        }

        @Override
        @NotNull
        public ChatFormatting asChatFormatting() {
            return Objects.requireNonNull(ChatFormatting.getByCode((char)this.getChar()));
        }
    }

    public static enum Format implements Type
    {
        OBFUSCATED("obfuscated", 'k'),
        BOLD("bold", 'l'),
        STRIKETHROUGH("strikethrough", 'm'),
        UNDERLINE("underline", 'n'),
        ITALIC("italic", 'o');

        private final String name;
        private final char c;

        private Format(String name, char c) {
            this.name = name;
            this.c = c;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public char getChar() {
            return this.c;
        }

        @Override
        @NotNull
        public ChatFormatting asChatFormatting() {
            return Objects.requireNonNull(ChatFormatting.getByCode((char)this.getChar()));
        }

        @Nullable
        public static Format fromChar(char c) {
            for (Format value : Format.values()) {
                if (value.c != c) continue;
                return value;
            }
            return null;
        }

        public static EnumSet<Format> fromCharAsSet(char c) {
            for (Format value : Format.values()) {
                if (value.c != c) continue;
                return EnumSet.of(value);
            }
            return EnumSet.noneOf(Format.class);
        }
    }

    public static interface Type {
        public String getName();

        public char getChar();

        public ChatFormatting asChatFormatting();

        default public boolean isColor() {
            return this instanceof Color;
        }

        default public boolean isFormat() {
            return this instanceof Format;
        }

        default public boolean isReset() {
            return this == RESET;
        }
    }

    public static class Reset
    implements Type {
        private Reset() {
        }

        @Override
        public String getName() {
            return "reset";
        }

        @Override
        public char getChar() {
            return 'r';
        }

        public StringBuilder append(StringBuilder sb) {
            sb.append('\u00a7').append(this.getChar());
            return sb;
        }

        @Override
        public ChatFormatting asChatFormatting() {
            return ChatFormatting.RESET;
        }
    }
}

