/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.mixin;

import io.github.mortuusars.scholar.book.BookColor;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.BookCloningRecipe;
import net.minecraft.world.item.crafting.CraftingInput;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BookCloningRecipe.class})
public class BookCloningRecipeMixin {
    @Inject(method={"assemble(Lnet/minecraft/world/item/crafting/CraftingInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAssemble(CraftingInput input, HolderLookup.Provider registries, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack inputBook = ItemStack.EMPTY;
        Integer resultColor = null;
        int copies = 0;
        for (int slot = 0; slot < input.size(); ++slot) {
            ItemStack stack = input.getItem(slot);
            if (stack.isEmpty()) continue;
            if (stack.is(Items.WRITTEN_BOOK)) {
                if (!inputBook.isEmpty()) {
                    cir.setReturnValue((Object)ItemStack.EMPTY);
                    return;
                }
                inputBook = stack;
                continue;
            }
            if (stack.is(Items.WRITABLE_BOOK)) {
                int color = BookColor.of(stack);
                if (resultColor == null) {
                    resultColor = color;
                } else if (resultColor != color) {
                    cir.setReturnValue((Object)ItemStack.EMPTY);
                    return;
                }
                ++copies;
                continue;
            }
            cir.setReturnValue((Object)ItemStack.EMPTY);
            return;
        }
        if (inputBook.isEmpty() || copies < 1) {
            cir.setReturnValue((Object)ItemStack.EMPTY);
            return;
        }
        @Nullable WrittenBookContent content = ((WrittenBookContent)inputBook.getOrDefault(DataComponents.WRITTEN_BOOK_CONTENT, (Object)WrittenBookContent.EMPTY)).tryCraftCopy();
        if (content == null) {
            cir.setReturnValue((Object)ItemStack.EMPTY);
            return;
        }
        ItemStack resultStack = inputBook.copyWithCount(copies);
        resultStack.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)content);
        BookColor.set(resultStack, resultColor);
        cir.setReturnValue((Object)resultStack);
    }
}

