/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.network.packet.server;

import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.network.packet.Packet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.TextFilter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import org.jetbrains.annotations.NotNull;

public record LecternEditBookC2SP(BlockPos lecternPos, List<String> pages, Optional<String> title) implements Packet
{
    public static final ResourceLocation ID = Scholar.resource("lectern_edit_book");
    public static final CustomPacketPayload.Type<LecternEditBookC2SP> TYPE = new CustomPacketPayload.Type(ID);
    public static final int TITLE_MAX_CHARS = 128;
    public static final int PAGE_MAX_CHARS = 8192;
    public static final int MAX_PAGES_COUNT = 200;
    public static final StreamCodec<FriendlyByteBuf, LecternEditBookC2SP> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, LecternEditBookC2SP::lecternPos, (StreamCodec)ByteBufCodecs.stringUtf8((int)8192).apply(ByteBufCodecs.list((int)200)), LecternEditBookC2SP::pages, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.stringUtf8((int)128)), LecternEditBookC2SP::title, LecternEditBookC2SP::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public boolean handle(PacketFlow direction, Player player) {
        if (!(player instanceof ServerPlayer)) {
            Scholar.LOGGER.error("Cannot handle {} packet: player is not ServerPlayer.", (Object)ID);
            return true;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockEntity blockEntity = player.level().getBlockEntity(this.lecternPos);
        if (!(blockEntity instanceof LecternBlockEntity)) {
            Scholar.LOGGER.error("Cannot update lectern book: no lectern block entity at lecternPos '{}'", (Object)this.lecternPos);
            return false;
        }
        LecternBlockEntity lecternBlockEntity = (LecternBlockEntity)blockEntity;
        ArrayList<String> bookPages = new ArrayList<String>();
        Optional<String> title = this.title();
        title.ifPresent(bookPages::add);
        this.pages().stream().limit(100L).forEach(bookPages::add);
        Consumer<List> consumer = title.isPresent() ? list -> this.signBook(serverPlayer, (FilteredText)list.getFirst(), list.subList(1, list.size()), lecternBlockEntity) : list -> this.updateBookContents(serverPlayer, (List<FilteredText>)list, lecternBlockEntity);
        this.filterTextPacket(serverPlayer, bookPages).thenAccept(consumer);
        return true;
    }

    private void updateBookContents(ServerPlayer player, List<FilteredText> pages, LecternBlockEntity lecternBlockEntity) {
        ItemStack itemStack = lecternBlockEntity.getBook();
        if (!itemStack.is(Items.WRITABLE_BOOK)) {
            return;
        }
        List<Filterable> list = pages.stream().map(text -> this.filterableFromOutgoing(player, (FilteredText)text)).toList();
        itemStack.set(DataComponents.WRITABLE_BOOK_CONTENT, (Object)new WritableBookContent(list));
    }

    private void signBook(ServerPlayer player, FilteredText title, List<FilteredText> pages, LecternBlockEntity lecternBlockEntity) {
        ItemStack itemStack = lecternBlockEntity.getBook();
        if (!itemStack.is(Items.WRITABLE_BOOK)) {
            return;
        }
        ItemStack writtenBookStack = itemStack.transmuteCopy((ItemLike)Items.WRITTEN_BOOK);
        writtenBookStack.remove(DataComponents.WRITABLE_BOOK_CONTENT);
        List<Filterable> list = pages.stream().map(filteredText -> this.filterableFromOutgoing(player, (FilteredText)filteredText).map(Component::literal).map(c -> c)).toList();
        writtenBookStack.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)new WrittenBookContent(this.filterableFromOutgoing(player, title), player.getName().getString(), 0, list, true));
        lecternBlockEntity.setBook(writtenBookStack, (Player)player);
    }

    private Filterable<String> filterableFromOutgoing(ServerPlayer player, FilteredText filteredText) {
        return player.isTextFilteringEnabled() ? Filterable.passThrough((Object)filteredText.filteredOrEmpty()) : Filterable.from((FilteredText)filteredText);
    }

    private <T, R> CompletableFuture<R> filterTextPacket(ServerPlayer player, T message, BiFunction<TextFilter, T, CompletableFuture<R>> processor) {
        return processor.apply(player.getTextFilter(), (TextFilter)message).thenApply(object -> {
            if (!player.connection.isAcceptingMessages()) {
                Scholar.LOGGER.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private CompletableFuture<List<FilteredText>> filterTextPacket(ServerPlayer player, List<String> texts) {
        return this.filterTextPacket(player, texts, TextFilter::processMessageBundle);
    }
}

