/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.chiseled_bookshelf;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.mortuusars.scholar.client.chiseled_bookshelf.ChiseledBookshelfColors;
import io.github.mortuusars.scholar.client.util.HexColor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.slf4j.Logger;

public class BookshelfItemColorsReloadListener
extends class_4309 {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<Map<class_2960, Integer>> CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, HexColor.CODEC);

    public BookshelfItemColorsReloadListener() {
        super(new Gson(), "chiseled_bookshelf/item_colors");
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        HashMap itemColors = new HashMap();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            class_2960 location = entry.getKey();
            if (!location.method_12836().equals("scholar")) {
                LOGGER.info("Ignoring chiseled bookshelf item color definition '{}' because it's not in Scholar namespace.", (Object)location);
                continue;
            }
            CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).ifError(err -> LOGGER.error("Contents of '{}' cannot be parsed as a valid id to color map: {}", (Object)location, err)).ifSuccess(data -> itemColors.putAll((Map)data.getFirst()));
        }
        ChiseledBookshelfColors.ITEM_COLORS = ImmutableMap.copyOf(itemColors);
    }
}

