/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.chiseled_bookshelf;

import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.book.BookColor;
import io.github.mortuusars.scholar.client.chiseled_bookshelf.BookshelfDefaultColors;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1799;
import net.minecraft.class_1840;
import net.minecraft.class_1843;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_7714;
import net.minecraft.class_7716;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ChiseledBookshelfColors {
    public static Map<class_2960, BookshelfDefaultColors> DEFAULT_SLOT_COLORS = Collections.emptyMap();
    public static Map<class_2960, Integer> ITEM_COLORS = Collections.emptyMap();

    public static int getSlotTintColor(class_2680 state, @Nullable class_1920 blockGetter, @Nullable class_2338 pos, int tintIndex) {
        class_2586 class_25862;
        if (blockGetter == null || pos == null || tintIndex < 0 || tintIndex > 5 || !((class_25862 = blockGetter.method_8321(pos)) instanceof class_7716)) {
            return ChiseledBookshelfColors.getDefaultTintColorForSlot(state, tintIndex);
        }
        class_7716 blockEntity = (class_7716)class_25862;
        class_1799 stackInSlot = blockEntity.method_5438(tintIndex);
        if (stackInSlot.method_7960()) {
            return -1;
        }
        if (stackInSlot.method_7909() instanceof class_1843 || stackInSlot.method_7909() instanceof class_1840) {
            return BookColor.of(stackInSlot);
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stackInSlot.method_7909());
        return ITEM_COLORS.getOrDefault(itemId, ChiseledBookshelfColors.getDefaultTintColorForSlot(state, tintIndex));
    }

    public static int getDefaultTintColorForSlot(class_2680 state, int slot) {
        class_2960 blockId = class_7923.field_41175.method_10221((Object)state.method_26204());
        return DEFAULT_SLOT_COLORS.getOrDefault(blockId, BookshelfDefaultColors.VANILLA).getDefaultTintForSlot(slot);
    }

    public static void setBookshelfRenderLayer(BiConsumer<class_2248, class_1921> consumer) {
        Scholar.LOGGER.info("Scholar is setting RenderType of all 'ChiseledBookShelfBlock's to 'cutout' so the books could have proper colors in bookshelves.");
        Scholar.LOGGER.info("If Chiseled Bookshelves do not look correctly, please report to the Scholar github.");
        class_7923.field_41175.method_10220().filter(bl -> bl instanceof class_7714).forEach(bl -> consumer.accept((class_2248)bl, class_1921.method_23581()));
    }

    public static void registerBookshelfBlockColors(BiConsumer<class_322, class_2248> consumer) {
        Scholar.LOGGER.info("Scholar is registering 'BlockColor' (tints) for all 'ChiseledBookShelfBlock's, so the books could have proper colors in bookshelves.");
        Scholar.LOGGER.info("If Chiseled Bookshelves do not look correctly, please report to the Scholar github.");
        class_7923.field_41175.method_10220().filter(bl -> bl instanceof class_7714).forEach(bl -> consumer.accept(ChiseledBookshelfColors::getSlotTintColor, (class_2248)bl));
    }
}

