/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.network.packet.server;

import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.network.packet.Packet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3722;
import net.minecraft.class_5513;
import net.minecraft.class_5837;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9262;
import net.minecraft.class_9301;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public record LecternEditBookC2SP(class_2338 lecternPos, List<String> pages, Optional<String> title) implements Packet
{
    public static final class_2960 ID = Scholar.resource("lectern_edit_book");
    public static final class_8710.class_9154<LecternEditBookC2SP> TYPE = new class_8710.class_9154(ID);
    public static final int TITLE_MAX_CHARS = 128;
    public static final int PAGE_MAX_CHARS = 8192;
    public static final int MAX_PAGES_COUNT = 200;
    public static final class_9139<class_2540, LecternEditBookC2SP> STREAM_CODEC = class_9139.method_56436((class_9139)class_2338.field_48404, LecternEditBookC2SP::lecternPos, (class_9139)class_9135.method_56364((int)8192).method_56433(class_9135.method_58000((int)200)), LecternEditBookC2SP::pages, (class_9139)class_9135.method_56382((class_9139)class_9135.method_56364((int)128)), LecternEditBookC2SP::title, LecternEditBookC2SP::new);

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Override
    public boolean handle(class_2598 direction, class_1657 player) {
        if (!(player instanceof class_3222)) {
            Scholar.LOGGER.error("Cannot handle {} packet: player is not ServerPlayer.", (Object)ID);
            return true;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_2586 class_25862 = player.method_37908().method_8321(this.lecternPos);
        if (!(class_25862 instanceof class_3722)) {
            Scholar.LOGGER.error("Cannot update lectern book: no lectern block entity at lecternPos '{}'", (Object)this.lecternPos);
            return false;
        }
        class_3722 lecternBlockEntity = (class_3722)class_25862;
        ArrayList<String> bookPages = new ArrayList<String>();
        Optional<String> title = this.title();
        title.ifPresent(bookPages::add);
        this.pages().stream().limit(100L).forEach(bookPages::add);
        Consumer<List> consumer = title.isPresent() ? list -> this.signBook(serverPlayer, (class_5837)list.getFirst(), list.subList(1, list.size()), lecternBlockEntity) : list -> this.updateBookContents(serverPlayer, (List<class_5837>)list, lecternBlockEntity);
        this.filterTextPacket(serverPlayer, bookPages).thenAccept(consumer);
        return true;
    }

    private void updateBookContents(class_3222 player, List<class_5837> pages, class_3722 lecternBlockEntity) {
        class_1799 itemStack = lecternBlockEntity.method_17520();
        if (!itemStack.method_31574(class_1802.field_8674)) {
            return;
        }
        List<class_9262> list = pages.stream().map(text -> this.filterableFromOutgoing(player, (class_5837)text)).toList();
        itemStack.method_57379(class_9334.field_49653, (Object)new class_9301(list));
    }

    private void signBook(class_3222 player, class_5837 title, List<class_5837> pages, class_3722 lecternBlockEntity) {
        class_1799 itemStack = lecternBlockEntity.method_17520();
        if (!itemStack.method_31574(class_1802.field_8674)) {
            return;
        }
        class_1799 writtenBookStack = itemStack.method_60503((class_1935)class_1802.field_8360);
        writtenBookStack.method_57381(class_9334.field_49653);
        List<class_9262> list = pages.stream().map(filteredText -> this.filterableFromOutgoing(player, (class_5837)filteredText).method_57138(class_2561::method_43470).method_57138(c -> c)).toList();
        writtenBookStack.method_57379(class_9334.field_49606, (Object)new class_9302(this.filterableFromOutgoing(player, title), player.method_5477().getString(), 0, list, true));
        lecternBlockEntity.method_17514(writtenBookStack, (class_1657)player);
    }

    private class_9262<String> filterableFromOutgoing(class_3222 player, class_5837 filteredText) {
        return player.method_33793() ? class_9262.method_57137((Object)filteredText.method_45061()) : class_9262.method_57134((class_5837)filteredText);
    }

    private <T, R> CompletableFuture<R> filterTextPacket(class_3222 player, T message, BiFunction<class_5513, T, CompletableFuture<R>> processor) {
        return processor.apply(player.method_31273(), (class_5513)message).thenApply(object -> {
            if (!player.field_13987.method_48106()) {
                Scholar.LOGGER.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private CompletableFuture<List<class_5837>> filterTextPacket(class_3222 player, List<String> texts) {
        return this.filterTextPacket(player, texts, class_5513::method_31289);
    }
}

