/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.screen;

import io.github.mortuusars.scholar.Config;
import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.ScholarClient;
import io.github.mortuusars.scholar.client.gui.widget.textbox.TextBox;
import io.github.mortuusars.scholar.client.util.RenderUtil;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_746;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public abstract class SpreadBookScreen
extends class_437 {
    public static final class_2960 TEXTURE = Scholar.resource("textures/gui/book.png");
    public static final int BOOK_WIDTH = 295;
    public static final int BOOK_HEIGHT = 180;
    public static final int TEXT_LEFT_X = 22;
    public static final int TEXT_RIGHT_X = 159;
    public static final int TEXT_Y = 21;
    public static final int TEXT_WIDTH = 114;
    public static final int TEXT_HEIGHT = 128;
    @NotNull
    protected final class_310 minecraft = class_310.method_1551();
    @NotNull
    protected final class_746 player;
    protected int bookColor;
    protected int textColor;
    protected int pageNumbersColor;
    protected int selectionColor;
    protected int selectionUnfocusedColor;
    protected int leftPos;
    protected int topPos;
    protected class_4185 prevPageButton;
    protected class_4185 nextPageButton;
    protected int currentSpread;

    public SpreadBookScreen(int bookColor) {
        super(class_333.field_18967);
        this.player = Objects.requireNonNull(this.minecraft.field_1724);
        this.bookColor = bookColor;
        this.textColor = Config.Client.getColor(Config.Client.TEXT_COLOR);
        this.pageNumbersColor = Config.Client.getColor(Config.Client.PAGE_NUMBERS_COLOR);
        this.selectionColor = Config.Client.getColor(Config.Client.SELECTION_COLOR);
        this.selectionUnfocusedColor = Config.Client.getColor(Config.Client.SELECTION_UNFOCUSED_COLOR);
    }

    public boolean method_25421() {
        return (Boolean)Config.Client.SCREEN_PAUSE.get();
    }

    protected void method_25426() {
        this.leftPos = (this.field_22789 - 295) / 2;
        this.topPos = (this.field_22790 - 180) / 2;
        this.createWidgets();
    }

    protected void createWidgets() {
        this.createPrevPageButton();
        this.createNextPageButton();
        this.createBottomButtons();
    }

    protected void createNextPageButton() {
        class_344 nextPageButton = new class_344(this.leftPos + 270, this.topPos + 156, 13, 15, 308, 0, 15, TEXTURE, 512, 512, button -> this.pageForward());
        nextPageButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"spectatorMenu.next_page")));
        this.nextPageButton = (class_4185)this.method_37063((class_364)nextPageButton);
    }

    protected void createPrevPageButton() {
        class_344 prevPageButton = new class_344(this.leftPos + 12, this.topPos + 156, 13, 15, 295, 0, 15, TEXTURE, 512, 512, button -> this.pageBack());
        prevPageButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"spectatorMenu.previous_page")));
        this.prevPageButton = (class_4185)this.method_37063((class_364)prevPageButton);
    }

    protected void createBottomButtons() {
        if (((Boolean)Config.Client.SHOW_DONE_BUTTON.get()).booleanValue()) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 60, this.topPos + 180 + 12, 120, 20).method_46431());
        }
    }

    protected void updateButtonVisibility() {
        this.prevPageButton.field_22764 = this.currentSpread > 0;
        this.nextPageButton.field_22764 = this.currentSpread < this.getSpreadCount() - 1;
    }

    protected void toggleBookTools() {
        boolean currentValue = (Boolean)Config.Client.EDIT_SCREEN_SHOW_EXTRA_TOOLS.get();
        Config.Client.EDIT_SCREEN_SHOW_EXTRA_TOOLS.set((Object)(!currentValue ? 1 : 0));
        Config.Client.EDIT_SCREEN_SHOW_EXTRA_TOOLS.save();
    }

    public boolean isToolsVisible() {
        return (Boolean)Config.Client.EDIT_SCREEN_SHOW_EXTRA_TOOLS.get();
    }

    public int getPageCount() {
        return 100;
    }

    public int getSpreadCount() {
        return (int)Math.ceil((double)this.getPageCount() / 2.0);
    }

    protected boolean pageBack() {
        if (this.currentSpread > 0) {
            --this.currentSpread;
            this.playPageTurnSound(0.8f);
            return true;
        }
        return false;
    }

    protected boolean pageForward() {
        if (this.currentSpread < this.getSpreadCount() - 1) {
            ++this.currentSpread;
            this.playPageTurnSound(1.0f);
            return true;
        }
        return false;
    }

    protected void renderBook(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtil.withColorMultiplied(this.bookColor, () -> guiGraphics.method_25293(TEXTURE, this.leftPos, this.topPos, 295, 180, 0.0f, 0.0f, 295, 180, 512, 512));
        guiGraphics.method_25293(TEXTURE, this.leftPos, this.topPos, 295, 180, 0.0f, 180.0f, 295, 180, 512, 512);
    }

    protected void renderPageNumbers(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int currentSpread) {
        this.renderLeftPageNumber(guiGraphics, mouseX, mouseY, partialTick, currentSpread, this.pageNumbersColor);
        this.renderRightPageNumber(guiGraphics, mouseX, mouseY, partialTick, currentSpread, this.pageNumbersColor);
    }

    protected void renderLeftPageNumber(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int currentSpread, int color) {
        String leftPageNumber = Integer.toString(currentSpread * 2 + 1);
        guiGraphics.method_51433(this.field_22793, leftPageNumber, this.leftPos + 69 + (8 - this.field_22793.method_1727(leftPageNumber) / 2), this.topPos + 157, color, false);
    }

    protected void renderRightPageNumber(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int currentSpread, int color) {
        String rightPageNumber = Integer.toString(currentSpread * 2 + 2);
        guiGraphics.method_51433(this.field_22793, rightPageNumber, this.leftPos + 208 + (8 - this.field_22793.method_1727(rightPageNumber) / 2), this.topPos + 157, color, false);
    }

    protected void renderTools(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (ScholarClient.KeyMappings.toggleBookTools.method_1417(keyCode, scanCode)) {
            this.toggleBookTools();
            return true;
        }
        if (!(this.method_25399() instanceof TextBox)) {
            if (class_310.method_1551().field_1690.field_1822.method_1417(keyCode, scanCode)) {
                this.method_25419();
                return true;
            }
            if (keyCode == 263 || keyCode == 266 || class_310.method_1551().field_1690.field_1913.method_1417(keyCode, scanCode)) {
                this.pageBack();
                return true;
            }
            if (keyCode == 262 || keyCode == 267 || class_310.method_1551().field_1690.field_1849.method_1417(keyCode, scanCode)) {
                this.pageForward();
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return (mouseX -= (double)this.leftPos) >= (double)(x - 1) && mouseX < (double)(x + width + 1) && (mouseY -= (double)this.topPos) >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    protected boolean isHoveringOverRightPageNumber(double mouseX, double mouseY) {
        return this.isHovering(206, 157, 17, 7, mouseX, mouseY);
    }

    protected boolean isHoveringOverLeftPageNumber(double mouseX, double mouseY) {
        return this.isHovering(66, 157, 17, 7, mouseX, mouseY);
    }

    protected boolean isLeftPage(int pageIndex) {
        return pageIndex % 2 == 0;
    }

    protected boolean isRightPage(int pageIndex) {
        return pageIndex % 2 == 1;
    }

    protected void playButtonClickSound(float volume, float pitch) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_15015.comp_349()), (float)pitch, (float)volume));
    }

    protected void playButtonClickSound(float pitch) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_15015.comp_349()), (float)pitch, (float)0.3f));
    }

    protected void playButtonClickSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_15015.comp_349()), (float)1.0f, (float)0.3f));
    }

    protected void playPageTurnSound(float volume, float pitch) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_17481, (float)pitch, (float)volume));
    }

    protected void playPageTurnSound(float pitch) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_17481, (float)pitch, (float)1.0f));
    }

    protected void playPageTurnSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_17481, (float)1.0f, (float)1.0f));
    }
}

