/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.widget.textbox.display;

import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.client.gui.widget.textbox.TextBox;
import io.github.mortuusars.scholar.client.gui.widget.textbox.display.HorizontalAlignment;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.Formatting;
import io.github.mortuusars.scholar.client.util.Pos2i;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_768;

public class FormattingToolbar {
    public static final class_2960 TEXTURE = Scholar.resource("textures/gui/formatting_toolbar.png");
    public static final Map<Character, String> HOTKEYS = new HashMap<Character, String>();
    protected final TextBox textBox;
    protected Positioner positioner = Positioner.ABOVE_SELECTION;
    protected int width;
    protected int height;
    protected int x;
    protected int y;
    protected boolean visible = true;
    protected boolean shouldUpdate = true;
    protected final List<FormattingButton> buttons = new ArrayList<FormattingButton>();

    public FormattingToolbar(TextBox textBox) {
        this.textBox = textBox;
        this.setup();
    }

    protected void setup() {
        this.buttons.clear();
        int x = 0;
        this.buttons.add(new FormattingButton(Formatting.Format.BOLD, new class_768(x, 0, 12, 15), new Pos2i(x, 0)));
        this.buttons.add(new FormattingButton(Formatting.Format.ITALIC, new class_768(x += 11, 0, 12, 15), new Pos2i(x, 0)));
        this.buttons.add(new FormattingButton(Formatting.Format.UNDERLINE, new class_768(x += 11, 0, 12, 15), new Pos2i(x, 0)));
        this.buttons.add(new FormattingButton(Formatting.Format.STRIKETHROUGH, new class_768(x += 11, 0, 12, 15), new Pos2i(x, 0)));
        this.buttons.add(new FormattingButton(Formatting.Format.OBFUSCATED, new class_768(x += 11, 0, 12, 15), new Pos2i(x, 0)));
        this.buttons.add(new FormattingButton(Formatting.RESET, new class_768((x += 12) - 8, -13, 19, 28), new Pos2i(x, 0)));
        x += 11;
        for (Formatting.Color color : Arrays.stream(Formatting.Color.values()).limit(8L).toList()) {
            this.buttons.add(new FormattingButton(color, new class_768(x, 0, 7, 7), new Pos2i(x + 8, 0)));
            x += 6;
        }
        ++x;
        for (Formatting.Color color : Arrays.stream(Formatting.Color.values()).skip(8L).toList()) {
            this.buttons.add(new FormattingButton(color, new class_768(x - 49, 6, 7, 9), new Pos2i(x + 8, 0)));
            x += 6;
        }
        this.width = this.buttons.stream().mapToInt(button -> button.area().method_3321() + button.area.method_3319()).max().orElse(0);
        this.height = this.buttons.stream().mapToInt(button -> button.area().method_3322() + button.area.method_3320()).max().orElse(0);
    }

    public TextBox getTextBox() {
        return this.textBox;
    }

    public Positioner getPositioner() {
        return this.positioner;
    }

    public FormattingToolbar setPositioner(Positioner positioner) {
        this.positioner = positioner;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public FormattingToolbar setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public boolean shouldUpdate() {
        return this.shouldUpdate;
    }

    public void scheduleUpdate() {
        this.shouldUpdate = true;
    }

    public void update() {
        Pos2i pos = this.positioner.position(this, this.getTextBox());
        this.x = pos.x;
        this.y = pos.y;
        for (FormattingButton button : this.buttons) {
            if (button.formatting() == Formatting.RESET) continue;
            button.highlighted = this.getTextBox().getEditor().getSelectedSpan().stream().allMatch(c -> c.hasFormatting(button.formatting()));
        }
        this.shouldUpdate = false;
    }

    public boolean shouldShow() {
        return this.getTextBox().method_25370() && this.getTextBox().getEditor().isSelecting();
    }

    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.isVisible() || !this.shouldShow()) {
            return;
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 500.0f);
        FormattingButton hoveredButton = null;
        for (FormattingButton button : this.buttons) {
            int vOffset = 0;
            if (button.disabled()) {
                vOffset = button.area.method_3320() * 2;
            } else if (button.highlighted()) {
                vOffset = button.area.method_3320();
            }
            if (hoveredButton == null && button.isHovering(mouseX - this.x, mouseY - this.y)) {
                hoveredButton = button;
                if (!button.disabled()) {
                    vOffset = button.area.method_3320();
                }
            }
            guiGraphics.method_25302(TEXTURE, this.x + button.area.method_3321(), this.y + button.area.method_3322(), button.uv.x, button.uv.y + vOffset, button.area.method_3319(), button.area.method_3320());
        }
        if (hoveredButton != null) {
            class_5250 component = class_2561.method_43471((String)("gui.scholar.formatting." + hoveredButton.formatting.getName())).method_27693(" \u00a78" + HOTKEYS.getOrDefault(Character.valueOf(hoveredButton.formatting.getChar()), ""));
            guiGraphics.method_51438(class_310.method_1551().field_1772, (class_2561)component, mouseX, mouseY + 20);
        }
        guiGraphics.method_51448().method_22909();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isVisible() && this.shouldShow() && button == 0) {
            for (FormattingButton formattingButton : this.buttons) {
                if (!formattingButton.isHovering((int)(mouseX - (double)this.x), (int)(mouseY - (double)this.y))) continue;
                this.getTextBox().getEditor().applyFormatting(Formatting.of(formattingButton.formatting()));
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_15015.comp_349()), (float)1.0f, (float)0.3f));
                return true;
            }
        }
        return false;
    }

    static {
        HOTKEYS.put(Character.valueOf(Formatting.Format.OBFUSCATED.getChar()), "Ctrl+K");
        HOTKEYS.put(Character.valueOf(Formatting.Format.BOLD.getChar()), "Ctrl+L");
        HOTKEYS.put(Character.valueOf(Formatting.Format.STRIKETHROUGH.getChar()), "Ctrl+M");
        HOTKEYS.put(Character.valueOf(Formatting.Format.UNDERLINE.getChar()), "Ctrl+N");
        HOTKEYS.put(Character.valueOf(Formatting.Format.ITALIC.getChar()), "Ctrl+O");
        HOTKEYS.put(Character.valueOf(Formatting.RESET.getChar()), "Ctrl+R");
        HOTKEYS.put(Character.valueOf(Formatting.Color.BLACK.getChar()), "Ctrl+1");
        HOTKEYS.put(Character.valueOf(Formatting.Color.DARK_BLUE.getChar()), "Ctrl+2");
        HOTKEYS.put(Character.valueOf(Formatting.Color.DARK_GREEN.getChar()), "Ctrl+3");
        HOTKEYS.put(Character.valueOf(Formatting.Color.DARK_AQUA.getChar()), "Ctrl+4");
        HOTKEYS.put(Character.valueOf(Formatting.Color.DARK_RED.getChar()), "Ctrl+5");
        HOTKEYS.put(Character.valueOf(Formatting.Color.DARK_PURPLE.getChar()), "Ctrl+6");
        HOTKEYS.put(Character.valueOf(Formatting.Color.GOLD.getChar()), "Ctrl+7");
        HOTKEYS.put(Character.valueOf(Formatting.Color.GRAY.getChar()), "Ctrl+8");
        HOTKEYS.put(Character.valueOf(Formatting.Color.DARK_GRAY.getChar()), "Ctrl+Shift+1");
        HOTKEYS.put(Character.valueOf(Formatting.Color.BLUE.getChar()), "Ctrl+Shift+2");
        HOTKEYS.put(Character.valueOf(Formatting.Color.GREEN.getChar()), "Ctrl+Shift+3");
        HOTKEYS.put(Character.valueOf(Formatting.Color.AQUA.getChar()), "Ctrl+Shift+4");
        HOTKEYS.put(Character.valueOf(Formatting.Color.RED.getChar()), "Ctrl+Shift+5");
        HOTKEYS.put(Character.valueOf(Formatting.Color.LIGHT_PURPLE.getChar()), "Ctrl+Shift+6");
        HOTKEYS.put(Character.valueOf(Formatting.Color.YELLOW.getChar()), "Ctrl+Shift+7");
        HOTKEYS.put(Character.valueOf(Formatting.Color.WHITE.getChar()), "Ctrl+Shift+8");
    }

    public static interface Positioner {
        public static final Positioner ABOVE_SELECTION = (toolbar, textBox) -> {
            int selectionStartY = textBox.getDisplayCache().getSelection().stream().mapToInt(class_768::method_3322).min().orElse(0);
            int x = textBox.method_46426() + HorizontalAlignment.CENTER.align(textBox.method_25368(), toolbar.getWidth());
            int n = textBox.method_46427() + selectionStartY;
            Objects.requireNonNull(textBox.getFont());
            int y = n - 9 - toolbar.getHeight();
            return new Pos2i(x, y);
        };

        public Pos2i position(FormattingToolbar var1, TextBox var2);
    }

    public static class FormattingButton {
        private final Formatting.Type formatting;
        private final class_768 area;
        private final Pos2i uv;
        private boolean disabled;
        private boolean highlighted;

        public FormattingButton(Formatting.Type formatting, class_768 area, Pos2i uv) {
            this.formatting = formatting;
            this.area = area;
            this.uv = uv;
        }

        public Formatting.Type formatting() {
            return this.formatting;
        }

        public class_768 area() {
            return this.area;
        }

        public Pos2i uv() {
            return this.uv;
        }

        public boolean disabled() {
            return this.disabled;
        }

        public boolean highlighted() {
            return this.highlighted;
        }

        public boolean isHovering(int mouseX, int mouseY) {
            return mouseX >= this.area.method_3321() && mouseX < this.area.method_3321() + this.area.method_3319() && mouseY >= this.area.method_3322() && mouseY < this.area.method_3322() + this.area.method_3320();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            FormattingButton that = (FormattingButton)obj;
            return Objects.equals(this.formatting, that.formatting) && Objects.equals(this.area, that.area) && Objects.equals(this.uv, that.uv) && this.disabled == that.disabled && this.highlighted == that.highlighted;
        }

        public int hashCode() {
            return Objects.hash(this.formatting, this.area, this.uv, this.disabled, this.highlighted);
        }

        public String toString() {
            return "FormattingButton[formatting=" + String.valueOf(this.formatting) + ", area=" + String.valueOf(this.area) + ", uv=" + String.valueOf(this.uv) + ", disabled=" + this.disabled + ", highlighted=" + this.highlighted + "]";
        }
    }
}

