/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.network;

import com.google.common.base.Preconditions;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.github.mortuusars.scholar.network.fabric.PacketsImpl;
import io.github.mortuusars.scholar.network.packet.IPacket;
import java.util.function.Predicate;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import org.jetbrains.annotations.Nullable;

public class Packets {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToServer(IPacket packet) {
        PacketsImpl.sendToServer(packet);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToClient(IPacket packet, class_3222 player) {
        void var1_1;
        PacketsImpl.sendToClient(packet, (class_3222)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToAllClients(IPacket packet) {
        PacketsImpl.sendToAllClients(packet);
    }

    public static void sendToClients(IPacket packet, class_3324 playerList, @Nullable class_3222 excludedPlayer) {
        for (class_3222 player : playerList.method_14571()) {
            if (player == excludedPlayer) continue;
            Packets.sendToClient(packet, player);
        }
    }

    public static void sendToClients(IPacket packet, class_3222 origin, Predicate<class_3222> filter) {
        Preconditions.checkState((origin.method_5682() != null ? 1 : 0) != 0, (Object)"Server cannot be null");
        for (class_3222 player : origin.method_5682().method_3760().method_14571()) {
            if (!filter.test(player)) continue;
            Packets.sendToClient(packet, player);
        }
    }

    public static void sendToOtherClients(IPacket packet, class_3222 excludedPlayer) {
        Packets.sendToClients(packet, excludedPlayer, (class_3222 serverPlayer) -> !serverPlayer.equals((Object)excludedPlayer));
    }

    public static void sendToOtherClients(IPacket packet, class_3222 excludedPlayer, Predicate<class_3222> filter) {
        Packets.sendToClients(packet, excludedPlayer, (class_3222 serverPlayer) -> !serverPlayer.equals((Object)excludedPlayer) && filter.test((class_3222)serverPlayer));
    }
}

