/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.network.fabric;

import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.network.PacketDirection;
import io.github.mortuusars.scholar.network.fabric.ClientPackets;
import io.github.mortuusars.scholar.network.packet.IPacket;
import io.github.mortuusars.scholar.network.packet.server.LecternEditBookC2SP;
import java.util.function.Function;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PacketsImpl {
    @Nullable
    private static MinecraftServer server;

    public static void registerC2SPackets() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)LecternEditBookC2SP.ID, (ServerPlayNetworking.PlayChannelHandler)new ServerHandler(LecternEditBookC2SP::fromBuffer));
    }

    public static void registerS2CPackets() {
        ClientPackets.registerS2CPackets();
    }

    public static void sendToServer(IPacket packet) {
        ClientPackets.sendToServer(packet);
    }

    public static void sendToClient(IPacket packet, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getId(), (class_2540)packet.toBuffer(PacketByteBufs.create()));
    }

    public static void sendToAllClients(IPacket packet) {
        if (server == null) {
            Scholar.LOGGER.error("Cannot send a packet to all players. Server is not present.");
            return;
        }
        class_2540 packetBuffer = packet.toBuffer(PacketByteBufs.create());
        for (class_3222 player : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getId(), (class_2540)packetBuffer);
        }
    }

    public static void onServerStarting(MinecraftServer server) {
        PacketsImpl.server = server;
    }

    public static void onServerStopped(MinecraftServer server) {
        PacketsImpl.server = null;
    }

    private record ServerHandler(Function<class_2540, IPacket> decodeFunction) implements ServerPlayNetworking.PlayChannelHandler
    {
        public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
            IPacket packet = this.decodeFunction.apply(buf);
            packet.handle(PacketDirection.TO_SERVER, (class_1657)player);
        }
    }
}

