/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.mortuusars.scholar.Scholar;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NbtTransferringRecipe
extends class_1852 {
    private final class_1799 result;
    private final class_1856 transferIngredient;
    private final class_2371<class_1856> ingredients;

    public NbtTransferringRecipe(class_2960 id, class_1856 transferIngredient, class_2371<class_1856> ingredients, class_1799 result) {
        super(id, class_7710.field_40251);
        this.transferIngredient = transferIngredient;
        this.ingredients = ingredients;
        this.result = result;
    }

    @NotNull
    public class_1856 getTransferIngredient() {
        return this.transferIngredient;
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return Scholar.RecipeSerializers.NBT_TRANSFERRING.get();
    }

    @NotNull
    public class_1799 method_8110(class_5455 registryAccess) {
        return this.getResult();
    }

    @NotNull
    public class_1799 getResult() {
        return this.result;
    }

    public boolean matches(class_8566 container, class_1937 level) {
        if (this.getTransferIngredient().method_8103() || this.ingredients.isEmpty()) {
            return false;
        }
        ArrayList<class_1856> unmatchedIngredients = new ArrayList<class_1856>((Collection<class_1856>)this.ingredients);
        unmatchedIngredients.add(0, this.getTransferIngredient());
        int itemsInCraftingGrid = 0;
        block0: for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (!stack.method_7960()) {
                ++itemsInCraftingGrid;
            }
            if (itemsInCraftingGrid > this.ingredients.size() + 1) {
                return false;
            }
            if (unmatchedIngredients.isEmpty()) continue;
            for (int j = 0; j < unmatchedIngredients.size(); ++j) {
                if (!((class_1856)unmatchedIngredients.get(j)).method_8093(stack)) continue;
                unmatchedIngredients.remove(j);
                continue block0;
            }
        }
        return unmatchedIngredients.isEmpty() && itemsInCraftingGrid == this.ingredients.size() + 1;
    }

    @NotNull
    public class_1799 assemble(class_8566 container, @NotNull class_5455 registryAccess) {
        for (int index = 0; index < container.method_5439(); ++index) {
            class_1799 itemStack = container.method_5438(index);
            if (!this.getTransferIngredient().method_8093(itemStack)) continue;
            return this.transferNbt(itemStack, this.method_8110(registryAccess).method_7972());
        }
        return this.method_8110(registryAccess);
    }

    @NotNull
    public class_1799 transferNbt(class_1799 transferIngredientStack, class_1799 recipeResultStack) {
        @Nullable class_2487 transferTag = transferIngredientStack.method_7969();
        if (transferTag != null) {
            if (recipeResultStack.method_7969() != null) {
                recipeResultStack.method_7969().method_10543(transferTag);
            } else {
                recipeResultStack.method_7980(transferTag.method_10553());
            }
        }
        return recipeResultStack;
    }

    public boolean method_8113(int width, int height) {
        return this.ingredients.size() <= width * height;
    }

    public static class Serializer
    implements class_1865<NbtTransferringRecipe> {
        @NotNull
        public NbtTransferringRecipe fromJson(class_2960 recipeId, JsonObject serializedRecipe) {
            class_1856 sourceIngredient = class_1856.method_52177((JsonElement)class_3518.method_52226((JsonObject)serializedRecipe, (String)"source"));
            class_2371<class_1856> ingredients = this.getIngredients(class_3518.method_15261((JsonObject)serializedRecipe, (String)"ingredients"));
            class_1799 result = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)serializedRecipe, (String)"result"));
            if (sourceIngredient.method_8103()) {
                throw new JsonParseException("Recipe should have 'source' ingredient.");
            }
            return new NbtTransferringRecipe(recipeId, sourceIngredient, ingredients, result);
        }

        @NotNull
        public NbtTransferringRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            class_1856 transferredIngredient = class_1856.method_8086((class_2540)buffer);
            int ingredientsCount = buffer.method_10816();
            class_2371 ingredients = class_2371.method_10213((int)ingredientsCount, (Object)class_1856.field_9017);
            ingredients.replaceAll(ignored -> class_1856.method_8086((class_2540)buffer));
            class_1799 result = buffer.method_10819();
            return new NbtTransferringRecipe(recipeId, transferredIngredient, (class_2371<class_1856>)ingredients, result);
        }

        public void toNetwork(class_2540 buffer, NbtTransferringRecipe recipe) {
            recipe.getTransferIngredient().method_8088(buffer);
            buffer.method_10804(recipe.method_8117().size());
            for (class_1856 ingredient : recipe.method_8117()) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.getResult());
        }

        private class_2371<class_1856> getIngredients(JsonArray jsonArray) {
            class_2371 ingredients = class_2371.method_10211();
            for (int i = 0; i < jsonArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_52177((JsonElement)jsonArray.get(i));
                if (ingredient.method_8103()) continue;
                ingredients.add((Object)ingredient);
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for a recipe.");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for a recipe. The maximum is 9.");
            }
            return ingredients;
        }
    }
}

