/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.render;

import io.github.mortuusars.scholar.Config;
import io.github.mortuusars.scholar.book.BookColor;
import io.github.mortuusars.scholar.integration.Mods;
import io.github.mortuusars.scholar.integration.mcbv.MoreChiseledBookshelfVariantsIntegration;
import io.github.mortuusars.scholar.integration.woodworks.WoodworksIntegration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class ChiseledBookShelf {
    public static final int DEFAULT_TINT_SLOT_0 = -15025988;
    public static final int DEFAULT_TINT_SLOT_1 = -8867520;
    public static final int DEFAULT_TINT_SLOT_2 = -5815323;
    public static final int DEFAULT_TINT_SLOT_3 = -2864530;
    public static final int DEFAULT_TINT_SLOT_4 = -2787242;
    public static final int DEFAULT_TINT_SLOT_5 = -13669434;
    public static final Map<ResourceLocation, Integer> CUSTOM_COLORS = new HashMap<ResourceLocation, Integer>();

    public static int getSlotTintColor(BlockState state, @Nullable BlockAndTintGetter blockGetter, @Nullable BlockPos pos, int tintIndex) {
        BlockEntity blockEntity;
        if (!((Boolean)Config.Common.CHISELED_BOOKSHELF_COLORS.get()).booleanValue()) {
            return ChiseledBookShelf.getDefaultTintColorForSlot(state, tintIndex);
        }
        if (blockGetter == null || pos == null || tintIndex < 0 || tintIndex > 5 || !((blockEntity = blockGetter.m_7702_(pos)) instanceof ChiseledBookShelfBlockEntity)) {
            return ChiseledBookShelf.getDefaultTintColorForSlot(state, tintIndex);
        }
        ChiseledBookShelfBlockEntity blockEntity2 = (ChiseledBookShelfBlockEntity)blockEntity;
        ItemStack stackInSlot = blockEntity2.m_8020_(tintIndex);
        if (stackInSlot.m_41619_()) {
            return -1;
        }
        if (stackInSlot.m_41720_() instanceof WrittenBookItem || stackInSlot.m_41720_() instanceof WritableBookItem) {
            return BookColor.of(stackInSlot);
        }
        return CUSTOM_COLORS.getOrDefault(BuiltInRegistries.f_257033_.m_7981_((Object)stackInSlot.m_41720_()), ChiseledBookShelf.getDefaultTintColorForSlot(state, tintIndex));
    }

    public static int getDefaultTintColorForSlot(BlockState state, int slot) {
        OptionalInt color;
        if (Mods.WOODWORKS.isLoaded() && (color = WoodworksIntegration.getDefaultTintColor(state, slot)).isPresent()) {
            return color.getAsInt();
        }
        return switch (slot) {
            case 1 -> -8867520;
            case 2 -> -5815323;
            case 3 -> -2864530;
            case 4 -> -2787242;
            case 5 -> -13669434;
            default -> -15025988;
        };
    }

    public static void renderSlotTooltip(GuiGraphics guiGraphics, float partialTick) {
        HitResult hitResult;
        if (!((Boolean)Config.Common.CHISELED_BOOKSHELF_TOOLTIP.get()).booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null || minecraft.f_91074_ == null || minecraft.f_91080_ != null || !((hitResult = minecraft.f_91077_) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        BlockPos hitPos = blockHitResult.m_82425_();
        BlockState blockState = minecraft.f_91073_.m_8055_(hitPos);
        if (!(blockState.m_60734_() instanceof ChiseledBookShelfBlock)) {
            return;
        }
        @Nullable BlockEntity blockEntity = minecraft.f_91073_.m_7702_(hitPos);
        if (!(blockEntity instanceof ChiseledBookShelfBlockEntity)) {
            return;
        }
        ChiseledBookShelfBlockEntity chiseledBookShelfBlockEntity = (ChiseledBookShelfBlockEntity)blockEntity;
        Optional blockHitPos = ChiseledBookShelfBlock.m_260871_((BlockHitResult)blockHitResult, (Direction)((Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
        if (blockHitPos.isEmpty()) {
            return;
        }
        int hitSlot = ChiseledBookShelf.getHitSlot(blockState, (Vec2)blockHitPos.get());
        ItemStack bookStack = chiseledBookShelfBlockEntity.m_8020_(hitSlot);
        if (bookStack.m_41619_()) {
            return;
        }
        int x = minecraft.m_91268_().m_85445_() / 2 + 16;
        int y = minecraft.m_91268_().m_85446_() / 2 - 9;
        TooltipRenderUtil.m_280205_((GuiGraphics)guiGraphics, (int)x, (int)y, (int)18, (int)18, (int)400);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        guiGraphics.m_280480_(bookStack, x + 1, y + 1);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280153_(minecraft.f_91062_, bookStack, x + 16, y + 12);
    }

    public static int getHitSlot(BlockState state, Vec2 hitPos) {
        OptionalInt slot;
        if (Mods.WOODWORKS.isLoaded() && (slot = WoodworksIntegration.getHitSlot(state, hitPos)).isPresent()) {
            return slot.getAsInt();
        }
        return ChiseledBookShelfBlock.m_261279_((Vec2)hitPos);
    }

    public static void registerBookshelfBlockColors(BiConsumer<BlockColor, Block> consumer) {
        consumer.accept(ChiseledBookShelf::getSlotTintColor, Blocks.f_244299_);
        if (Mods.MCBV.isLoading()) {
            MoreChiseledBookshelfVariantsIntegration.registerBlockColors(consumer);
        }
        if (Mods.WOODWORKS.isLoading()) {
            WoodworksIntegration.registerBlockColors(consumer);
        }
    }

    public static void setBookshelfRenderLayer(BiConsumer<Block, RenderType> consumer) {
        consumer.accept(Blocks.f_244299_, RenderType.m_110463_());
        if (Mods.MCBV.isLoading()) {
            MoreChiseledBookshelfVariantsIntegration.setRenderLayer(consumer);
        }
        if (Mods.WOODWORKS.isLoading()) {
            WoodworksIntegration.setRenderLayer(consumer);
        }
    }

    static {
        CUSTOM_COLORS.put(new ResourceLocation("minecraft:book"), -6523330);
        CUSTOM_COLORS.put(new ResourceLocation("exposure:album"), -6013396);
        CUSTOM_COLORS.put(new ResourceLocation("exposure:signed_album"), -6013396);
    }
}

