/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.forge.event;

import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.ScholarClient;
import io.github.mortuusars.scholar.book.BookColor;
import io.github.mortuusars.scholar.client.gui.screen.edit.LecternSpreadBookEditScreen;
import io.github.mortuusars.scholar.client.gui.screen.view.LecternSpreadBookViewScreen;
import io.github.mortuusars.scholar.client.render.ChiseledBookShelf;
import io.github.mortuusars.scholar.client.resource.BuiltInResourcePacks;
import io.github.mortuusars.scholar.forge.resource.ModFilePackResources;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientEvents {

    @Mod.EventBusSubscriber(modid="scholar", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ForgeBus {
        @SubscribeEvent
        public static void onRenderGuiPost(RenderGuiEvent.Post event) {
            ChiseledBookShelf.renderSlotTooltip(event.getGuiGraphics(), event.getPartialTick());
        }
    }

    @Mod.EventBusSubscriber(modid="scholar", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModBus {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                ScholarClient.init();
                MenuScreens.m_96206_(Scholar.MenuTypes.LECTERN_SPREAD_BOOK_VIEW.get(), LecternSpreadBookViewScreen::new);
                MenuScreens.m_96206_(Scholar.MenuTypes.LECTERN_SPREAD_BOOK_EDIT.get(), LecternSpreadBookEditScreen::new);
                ChiseledBookShelf.setBookshelfRenderLayer(ItemBlockRenderTypes::setRenderLayer);
            });
        }

        @SubscribeEvent
        public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
            ChiseledBookShelf.registerBookshelfBlockColors((x$0, xva$1) -> event.register(x$0, new Block[]{xva$1}));
        }

        @SubscribeEvent
        public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
            event.register(BookColor::getItemTintColor, new ItemLike[]{Items.f_42614_});
            event.register(BookColor::getItemTintColor, new ItemLike[]{Items.f_42615_});
        }

        @SubscribeEvent
        public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            ScholarClient.KeyMappings.register(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
        }

        @SubscribeEvent
        public static void addPacks(AddPackFindersEvent event) {
            if (event.getPackType() != PackType.CLIENT_RESOURCES) {
                return;
            }
            ModList.get().getModContainerById("scholar").ifPresent(modContainer -> event.addRepositorySource(packConsumer -> {
                for (BuiltInResourcePacks.Pack pack : BuiltInResourcePacks.get()) {
                    Pack createdPack = Pack.m_245429_((String)pack.id().toString(), (Component)pack.name(), (pack.activation().forge() == BuiltInResourcePacks.ActivationType.ALWAYS_ENABLED ? 1 : 0) != 0, id -> new ModFilePackResources(id, modContainer.getModInfo().getOwningFile().getFile(), "resourcepacks/" + pack.id().m_135815_(), true), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                    packConsumer.accept(createdPack);
                }
            }));
        }
    }
}

