/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.mixin;

import io.github.mortuusars.scholar.Config;
import io.github.mortuusars.scholar.menu.Lectern;
import io.github.mortuusars.scholar.menu.LecternSpreadBookEditMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LecternBlock.class}, priority=990)
public abstract class LecternBlockMixin {
    @Inject(method={"openScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void openScreen(Level level, BlockPos pos, Player player, CallbackInfo ci) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof LecternBlockEntity)) {
            return;
        }
        LecternBlockEntity lecternBlockEntity = (LecternBlockEntity)blockEntity;
        if (!((Boolean)Config.Common.LECTERN_TWO_PAGE_BOOK_SCREEN.get()).booleanValue()) {
            return;
        }
        if (((Boolean)Config.Common.SNEAK_OPENS_VANILLA_BOOK_SCREEN.get()).booleanValue() && player.m_36341_()) {
            return;
        }
        ItemStack bookStack = lecternBlockEntity.m_59566_();
        if (bookStack.m_150930_(Items.f_42614_)) {
            boolean hasPlayerEditing = serverPlayer.m_284548_().m_6907_().stream().anyMatch(pl -> {
                LecternSpreadBookEditMenu lecternMenu;
                AbstractContainerMenu patt0$temp = pl.f_36096_;
                return patt0$temp instanceof LecternSpreadBookEditMenu && (lecternMenu = (LecternSpreadBookEditMenu)patt0$temp).getLecternPos().equals((Object)pos);
            });
            if (hasPlayerEditing) {
                Lectern.openBookViewMenu(serverPlayer, lecternBlockEntity, bookStack);
            } else {
                Lectern.openBookEditMenu(serverPlayer, lecternBlockEntity, bookStack);
            }
            player.m_36220_(Stats.f_12974_);
            ci.cancel();
        }
        if (bookStack.m_150930_(Items.f_42615_)) {
            Lectern.openBookViewMenu(serverPlayer, lecternBlockEntity, bookStack);
            player.m_36220_(Stats.f_12974_);
            ci.cancel();
        }
    }
}

