/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.network.packet.server;

import com.google.common.collect.Lists;
import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.network.PacketDirection;
import io.github.mortuusars.scholar.network.packet.IPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.TextFilter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import org.jetbrains.annotations.Nullable;

public record LecternEditBookC2SP(BlockPos lecternPos, List<String> pages, Optional<String> title) implements IPacket
{
    public static final ResourceLocation ID = Scholar.resource("lectern_edit_book");
    private static final int TITLE_MAX_CHARS = 128;
    private static final int PAGE_MAX_CHARS = 8192;
    private static final int MAX_PAGES_COUNT = 200;

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public static LecternEditBookC2SP fromBuffer(FriendlyByteBuf buffer) {
        return new LecternEditBookC2SP(buffer.m_130135_(), (List)buffer.m_236838_(FriendlyByteBuf.m_182695_(Lists::newArrayListWithCapacity, (int)200), friendlyByteBuf -> friendlyByteBuf.m_130136_(8192)), buffer.m_236860_(friendlyByteBuf -> friendlyByteBuf.m_130136_(128)));
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.lecternPos);
        buffer.m_236828_(this.pages, (friendlyByteBuf, string) -> friendlyByteBuf.m_130072_(string, 8192));
        buffer.m_236835_(this.title, (friendlyByteBuf, string) -> friendlyByteBuf.m_130072_(string, 128));
        return buffer;
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        if (!(player instanceof ServerPlayer)) {
            Scholar.LOGGER.error("Cannot handle {} packet: player is not ServerPlayer.", (Object)this.getId());
            return true;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockEntity blockEntity = player.m_9236_().m_7702_(this.lecternPos);
        if (!(blockEntity instanceof LecternBlockEntity)) {
            Scholar.LOGGER.error("Cannot update lectern book: no lectern block entity at lecternPos '{}'", (Object)this.lecternPos);
            return false;
        }
        LecternBlockEntity lecternBlockEntity = (LecternBlockEntity)blockEntity;
        ArrayList<String> bookPages = new ArrayList<String>();
        Optional<String> title = this.title();
        title.ifPresent(bookPages::add);
        this.pages().stream().limit(100L).forEach(bookPages::add);
        Consumer<List> consumer = title.isPresent() ? list -> this.signBook(serverPlayer, (FilteredText)list.get(0), list.subList(1, list.size()), lecternBlockEntity) : list -> this.updateBookContents(serverPlayer, (List<FilteredText>)list, lecternBlockEntity);
        this.filterTextPacket(serverPlayer, bookPages).thenAccept(consumer);
        return true;
    }

    private void updateBookContents(ServerPlayer player, List<FilteredText> pages, LecternBlockEntity lecternBlockEntity) {
        ItemStack itemStack = lecternBlockEntity.m_59566_();
        if (!itemStack.m_150930_(Items.f_42614_)) {
            return;
        }
        this.updateBookPages(player, pages, UnaryOperator.identity(), itemStack, lecternBlockEntity);
    }

    private void signBook(ServerPlayer player, FilteredText title, List<FilteredText> pages, LecternBlockEntity lecternBlockEntity) {
        ItemStack itemStack = lecternBlockEntity.m_59566_();
        if (!itemStack.m_150930_(Items.f_42614_)) {
            return;
        }
        ItemStack writtenBookStack = new ItemStack((ItemLike)Items.f_42615_);
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag != null) {
            writtenBookStack.m_41751_(compoundTag.m_6426_());
        }
        writtenBookStack.m_41700_("author", (Tag)StringTag.m_129297_((String)player.m_7755_().getString()));
        if (player.m_143387_()) {
            writtenBookStack.m_41700_("title", (Tag)StringTag.m_129297_((String)title.m_243113_()));
        } else {
            writtenBookStack.m_41700_("filtered_title", (Tag)StringTag.m_129297_((String)title.m_243113_()));
            writtenBookStack.m_41700_("title", (Tag)StringTag.m_129297_((String)title.f_215168_()));
        }
        this.updateBookPages(player, pages, string -> Component.Serializer.m_130703_((Component)Component.m_237113_((String)string)), writtenBookStack, lecternBlockEntity);
        lecternBlockEntity.m_59538_(writtenBookStack, (Player)player);
    }

    private void updateBookPages(ServerPlayer player, List<FilteredText> pages, UnaryOperator<String> updater, ItemStack book, LecternBlockEntity lecternBlockEntity) {
        ListTag listTag = new ListTag();
        if (player.m_143387_()) {
            pages.stream().map(filteredText -> StringTag.m_129297_((String)((String)updater.apply(filteredText.m_243113_())))).forEach(arg_0 -> listTag.add(arg_0));
        } else {
            CompoundTag compoundTag = new CompoundTag();
            int j = pages.size();
            for (int i = 0; i < j; ++i) {
                FilteredText filteredText2 = pages.get(i);
                String string = filteredText2.f_215168_();
                listTag.add((Object)StringTag.m_129297_((String)((String)updater.apply(string))));
                if (!filteredText2.m_215174_()) continue;
                compoundTag.m_128359_(String.valueOf(i), (String)updater.apply(filteredText2.m_243113_()));
            }
            if (!compoundTag.m_128456_()) {
                book.m_41700_("filtered_pages", (Tag)compoundTag);
            }
        }
        book.m_41700_("pages", (Tag)listTag);
    }

    private <T, R> CompletableFuture<R> filterTextPacket(ServerPlayer player, T message, BiFunction<TextFilter, T, CompletableFuture<R>> processor) {
        return processor.apply(player.m_8967_(), (TextFilter)message).thenApply(object -> {
            if (!player.f_8906_.m_6198_()) {
                Scholar.LOGGER.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private CompletableFuture<List<FilteredText>> filterTextPacket(ServerPlayer player, List<String> texts) {
        return this.filterTextPacket(player, texts, TextFilter::m_5925_);
    }
}

