/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.render;

import io.github.mortuusars.scholar.Config;
import io.github.mortuusars.scholar.book.BookColor;
import io.github.mortuusars.scholar.integration.Mods;
import io.github.mortuusars.scholar.integration.mcbv.MoreChiseledBookshelfVariantsIntegration;
import io.github.mortuusars.scholar.integration.woodster.WoodsterIntegration;
import io.github.mortuusars.scholar.integration.woodworks.WoodworksIntegration;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class ChiseledBookShelf {
    public static final int DEFAULT_TINT_SLOT_0 = -15025988;
    public static final int DEFAULT_TINT_SLOT_1 = -8867520;
    public static final int DEFAULT_TINT_SLOT_2 = -5815323;
    public static final int DEFAULT_TINT_SLOT_3 = -2864530;
    public static final int DEFAULT_TINT_SLOT_4 = -2787242;
    public static final int DEFAULT_TINT_SLOT_5 = -13669434;
    public static final Map<ResourceLocation, Integer> CUSTOM_COLORS = new HashMap<ResourceLocation, Integer>();

    public static int getSlotTintColor(BlockState state, @Nullable BlockAndTintGetter blockGetter, @Nullable BlockPos pos, int tintIndex) {
        BlockEntity blockEntity;
        if (!((Boolean)Config.Common.CHISELED_BOOKSHELF_COLORS.get()).booleanValue()) {
            return ChiseledBookShelf.getDefaultTintColorForSlot(state, tintIndex);
        }
        if (blockGetter == null || pos == null || tintIndex < 0 || tintIndex > 5 || !((blockEntity = blockGetter.getBlockEntity(pos)) instanceof ChiseledBookShelfBlockEntity)) {
            return ChiseledBookShelf.getDefaultTintColorForSlot(state, tintIndex);
        }
        ChiseledBookShelfBlockEntity blockEntity2 = (ChiseledBookShelfBlockEntity)blockEntity;
        ItemStack stackInSlot = blockEntity2.getItem(tintIndex);
        if (stackInSlot.isEmpty()) {
            return -1;
        }
        if (stackInSlot.getItem() instanceof WrittenBookItem || stackInSlot.getItem() instanceof WritableBookItem) {
            return BookColor.of(stackInSlot);
        }
        return CUSTOM_COLORS.getOrDefault(BuiltInRegistries.ITEM.getKey((Object)stackInSlot.getItem()), ChiseledBookShelf.getDefaultTintColorForSlot(state, tintIndex));
    }

    public static int getDefaultTintColorForSlot(BlockState state, int slot) {
        OptionalInt color;
        if (Mods.WOODWORKS.isLoaded() && (color = WoodworksIntegration.getDefaultTintColor(state, slot)).isPresent()) {
            return color.getAsInt();
        }
        if (Mods.WOODSTER.isLoaded() && (color = WoodsterIntegration.getDefaultTintColor(state, slot)).isPresent()) {
            return color.getAsInt();
        }
        return switch (slot) {
            case 1 -> -8867520;
            case 2 -> -5815323;
            case 3 -> -2864530;
            case 4 -> -2787242;
            case 5 -> -13669434;
            default -> -15025988;
        };
    }

    public static void renderSlotTooltip(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        HitResult hitResult;
        if (!((Boolean)Config.Common.CHISELED_BOOKSHELF_TOOLTIP.get()).booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null || minecraft.player == null || minecraft.screen != null || !((hitResult = minecraft.hitResult) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        BlockPos hitPos = blockHitResult.getBlockPos();
        BlockState blockState = minecraft.level.getBlockState(hitPos);
        Block block = blockState.getBlock();
        if (!(block instanceof ChiseledBookShelfBlock)) {
            return;
        }
        ChiseledBookShelfBlock chiseledBookShelfBlock = (ChiseledBookShelfBlock)block;
        @Nullable BlockEntity blockEntity = minecraft.level.getBlockEntity(hitPos);
        if (!(blockEntity instanceof ChiseledBookShelfBlockEntity)) {
            return;
        }
        ChiseledBookShelfBlockEntity chiseledBookShelfBlockEntity = (ChiseledBookShelfBlockEntity)blockEntity;
        OptionalInt hitSlot = chiseledBookShelfBlock.getHitSlot(blockHitResult, blockState);
        if (hitSlot.isEmpty()) {
            return;
        }
        ItemStack bookStack = chiseledBookShelfBlockEntity.getItem(hitSlot.getAsInt());
        if (bookStack.isEmpty()) {
            return;
        }
        int x = minecraft.getWindow().getGuiScaledWidth() / 2 + 16;
        int y = minecraft.getWindow().getGuiScaledHeight() / 2 - 9;
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)x, (int)y, (int)18, (int)18, (int)400);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 400.0f);
        guiGraphics.renderItem(bookStack, x + 1, y + 1);
        guiGraphics.pose().popPose();
        guiGraphics.renderTooltip(minecraft.font, bookStack, x + 16, y + 12);
    }

    public static void registerBookshelfBlockColors(BiConsumer<BlockColor, Block> consumer) {
        consumer.accept(ChiseledBookShelf::getSlotTintColor, Blocks.CHISELED_BOOKSHELF);
        if (Mods.MCBV.isLoading()) {
            MoreChiseledBookshelfVariantsIntegration.registerBlockColors(consumer);
        }
        if (Mods.WOODWORKS.isLoading()) {
            WoodworksIntegration.registerBlockColors(consumer);
        }
        if (Mods.WOODSTER.isLoading()) {
            WoodsterIntegration.registerBlockColors(consumer);
        }
    }

    public static void setBookshelfRenderLayer(BiConsumer<Block, RenderType> consumer) {
        consumer.accept(Blocks.CHISELED_BOOKSHELF, RenderType.cutout());
        if (Mods.MCBV.isLoading()) {
            MoreChiseledBookshelfVariantsIntegration.setRenderLayer(consumer);
        }
        if (Mods.WOODWORKS.isLoading()) {
            WoodworksIntegration.setRenderLayer(consumer);
        }
        if (Mods.WOODSTER.isLoading()) {
            WoodsterIntegration.setRenderLayer(consumer);
        }
    }

    static {
        CUSTOM_COLORS.put(ResourceLocation.parse((String)"minecraft:book"), -6523330);
        CUSTOM_COLORS.put(ResourceLocation.parse((String)"exposure:album"), -6013396);
        CUSTOM_COLORS.put(ResourceLocation.parse((String)"exposure:signed_album"), -6013396);
    }
}

