/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.menu;

import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.book.Spread;
import io.github.mortuusars.scholar.menu.Lectern;
import io.github.mortuusars.scholar.menu.LecternSpreadMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import org.jetbrains.annotations.NotNull;

public class LecternSpreadBookEditMenu
extends LecternSpreadMenu {
    public LecternSpreadBookEditMenu(int containerId, Container lectern, ContainerData lecternData, BlockPos lecternPos) {
        super(containerId, lectern, lecternData, lecternPos);
    }

    public static LecternSpreadBookEditMenu fromBuffer(int containerId, Inventory inventory, RegistryFriendlyByteBuf buffer) {
        return new LecternSpreadBookEditMenu(containerId, (Container)new SimpleContainer(new ItemStack[]{(ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer)}), (ContainerData)new SimpleContainerData(1), buffer.readBlockPos());
    }

    @Override
    @NotNull
    public MenuType<?> getType() {
        return Scholar.MenuTypes.LECTERN_SPREAD_BOOK_EDIT.get();
    }

    @Override
    protected int getPageCount() {
        return 100;
    }

    @Override
    protected int getSpreadCount() {
        return 50;
    }

    @Override
    public boolean clickMenuButton(Player player, int buttonId) {
        if (buttonId == 1 || buttonId == 2) {
            int currentSpreadIndex = this.getCurrentSpread();
            int newSpreadIndex = currentSpreadIndex + (buttonId == 1 ? -1 : 1);
            if (newSpreadIndex < 0 || newSpreadIndex > this.getSpreadCount() - 1) {
                return true;
            }
            int newPageIndex = Spread.Side.LEFT.getPageIndexFromSpread(newSpreadIndex);
            BlockEntity blockEntity = player.level().getBlockEntity(this.getLecternPos());
            if (blockEntity instanceof LecternBlockEntity) {
                LecternBlockEntity lecternBlockEntity = (LecternBlockEntity)blockEntity;
                lecternBlockEntity.pageCount = Math.min(100, Spread.Side.RIGHT.getPageIndexFromSpread(newSpreadIndex) + 2);
            }
            this.setData(0, newPageIndex);
            return true;
        }
        return super.clickMenuButton(player, buttonId);
    }

    public void removed(Player player) {
        super.removed(player);
        if (player instanceof ServerPlayer) {
            LecternBlockEntity be;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = player.level().getBlockEntity(this.getLecternPos());
            if (blockEntity instanceof LecternBlockEntity && (be = (LecternBlockEntity)blockEntity).hasBook()) {
                serverPlayer.serverLevel().players().stream().filter(pl -> {
                    LecternSpreadMenu lecternMenu;
                    AbstractContainerMenu patt0$temp;
                    return !pl.equals((Object)serverPlayer) && (patt0$temp = pl.containerMenu) instanceof LecternSpreadMenu && (lecternMenu = (LecternSpreadMenu)patt0$temp).getLecternPos().equals((Object)this.getLecternPos());
                }).findFirst().ifPresent(pl -> {
                    pl.closeContainer();
                    if (be.getBook().getItem() instanceof WritableBookItem) {
                        Lectern.openBookEditMenu(pl, be, be.getBook());
                    }
                });
            }
        }
    }
}

