/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.book;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class BookColor {
    public static final BookColor DEFAULT = new BookColor(-6732498, null);
    private final int color;
    @Nullable
    private final DyeColor dyeColor;
    public static final List<BookColor> COLORS = Collections.synchronizedList(new ArrayList());
    public static final String TAG_COLOR = "color";
    public static final String TAG_DISPLAY = "display";

    public BookColor(int color, @Nullable DyeColor dyeColor) {
        this.color = color;
        this.dyeColor = dyeColor;
    }

    public int getValue() {
        return this.color;
    }

    public Optional<DyeColor> getDyeColor() {
        return Optional.ofNullable(this.dyeColor);
    }

    public ItemStack createWritableBook() {
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42614_);
        BookColor.set(itemStack, this);
        return itemStack;
    }

    public static int of(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41737_(TAG_DISPLAY);
        if (compoundTag != null && compoundTag.m_128425_(TAG_COLOR, 99)) {
            return compoundTag.m_128451_(TAG_COLOR);
        }
        return DEFAULT.getValue();
    }

    public static int getItemTintColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            return BookColor.of(stack);
        }
        return -1;
    }

    public static boolean hasCustomColor(ItemStack stack) {
        DyeableLeatherItem dyeableLeatherItem;
        Item item = stack.m_41720_();
        return item instanceof DyeableLeatherItem && (dyeableLeatherItem = (DyeableLeatherItem)item).m_41113_(stack);
    }

    public static void clear(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof DyeableLeatherItem) {
            DyeableLeatherItem dyeableLeatherItem = (DyeableLeatherItem)item;
            dyeableLeatherItem.m_41123_(stack);
        }
    }

    public static void set(ItemStack stack, BookColor color) {
        BookColor.set(stack, color.getValue());
    }

    public static void set(ItemStack stack, int color) {
        Item item = stack.m_41720_();
        if (item instanceof DyeableLeatherItem) {
            DyeableLeatherItem dyeableLeatherItem = (DyeableLeatherItem)item;
            dyeableLeatherItem.m_41115_(stack, color);
        }
    }

    static {
        COLORS.add(new BookColor(0xFAFEFF, DyeColor.WHITE));
        COLORS.add(new BookColor(0xCCCCC8, DyeColor.LIGHT_GRAY));
        COLORS.add(new BookColor(9014671, DyeColor.GRAY));
        COLORS.add(new BookColor(0x424244, DyeColor.BLACK));
        COLORS.add(new BookColor(8869684, DyeColor.BROWN));
        COLORS.add(new BookColor(13583420, DyeColor.RED));
        COLORS.add(new BookColor(15960885, DyeColor.ORANGE));
        COLORS.add(new BookColor(16044358, DyeColor.YELLOW));
        COLORS.add(new BookColor(10016832, DyeColor.LIME));
        COLORS.add(new BookColor(6395166, DyeColor.GREEN));
        COLORS.add(new BookColor(3186333, DyeColor.CYAN));
        COLORS.add(new BookColor(7458026, DyeColor.LIGHT_BLUE));
        COLORS.add(new BookColor(4936368, DyeColor.BLUE));
        COLORS.add(new BookColor(9123257, DyeColor.PURPLE));
        COLORS.add(new BookColor(13000637, DyeColor.MAGENTA));
        COLORS.add(new BookColor(16091303, DyeColor.PINK));
    }
}

