/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.chiseled_bookshelf;

import io.github.mortuusars.scholar.Config;
import io.github.mortuusars.scholar.integration.Mods;
import io.github.mortuusars.scholar.integration.woodworks.WoodworksIntegration;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class ChiseledBookshelfTooltip {
    public static void renderSlotTooltip(GuiGraphics guiGraphics, float partialTick) {
        HitResult hitResult;
        if (!((Boolean)Config.Common.CHISELED_BOOKSHELF_TOOLTIP.get()).booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null || minecraft.f_91074_ == null || minecraft.f_91080_ != null || !((hitResult = minecraft.f_91077_) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        BlockPos hitPos = blockHitResult.m_82425_();
        BlockState blockState = minecraft.f_91073_.m_8055_(hitPos);
        if (!(blockState.m_60734_() instanceof ChiseledBookShelfBlock)) {
            return;
        }
        @Nullable BlockEntity blockEntity = minecraft.f_91073_.m_7702_(hitPos);
        if (!(blockEntity instanceof ChiseledBookShelfBlockEntity)) {
            return;
        }
        ChiseledBookShelfBlockEntity chiseledBookShelfBlockEntity = (ChiseledBookShelfBlockEntity)blockEntity;
        Optional blockHitPos = ChiseledBookShelfBlock.m_260871_((BlockHitResult)blockHitResult, (Direction)((Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
        if (blockHitPos.isEmpty()) {
            return;
        }
        int hitSlot = ChiseledBookshelfTooltip.getHitSlot(blockState, (Vec2)blockHitPos.get());
        ItemStack bookStack = chiseledBookShelfBlockEntity.m_8020_(hitSlot);
        if (bookStack.m_41619_()) {
            return;
        }
        int x = minecraft.m_91268_().m_85445_() / 2 + 16;
        int y = minecraft.m_91268_().m_85446_() / 2 - 9;
        TooltipRenderUtil.m_280205_((GuiGraphics)guiGraphics, (int)x, (int)y, (int)18, (int)18, (int)400);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        guiGraphics.m_280480_(bookStack, x + 1, y + 1);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280153_(minecraft.f_91062_, bookStack, x + 16, y + 12);
    }

    private static int getHitSlot(BlockState state, Vec2 hitPos) {
        OptionalInt slot;
        if (Mods.WOODWORKS.isLoaded() && (slot = WoodworksIntegration.getHitSlot(state, hitPos)).isPresent()) {
            return slot.getAsInt();
        }
        return ChiseledBookShelfBlock.m_261279_((Vec2)hitPos);
    }
}

