/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.screen.edit;

import com.google.common.base.Preconditions;
import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.ScholarClient;
import io.github.mortuusars.scholar.book.BookColor;
import io.github.mortuusars.scholar.book.Spread;
import io.github.mortuusars.scholar.client.gui.screen.BookSigningScreen;
import io.github.mortuusars.scholar.client.gui.screen.SpreadBookScreen;
import io.github.mortuusars.scholar.client.gui.widget.textbox.TextBox;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.Char;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedString;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedStringEditor;
import io.github.mortuusars.scholar.client.util.FileDialogs;
import io.github.mortuusars.scholar.client.util.RenderUtil;
import io.github.mortuusars.scholar.util.Change;
import io.github.mortuusars.scholar.util.History;
import io.netty.util.internal.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundEditBookPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpreadBookEditScreen
extends SpreadBookScreen {
    protected final ItemStack bookStack;
    protected final InteractionHand hand;
    protected final List<String> pages = new ArrayList<String>();
    protected final History history = new History();
    protected TextBox rightPageTextBox;
    protected TextBox leftPageTextBox;
    protected ImageButton insertEmptyPageLeftButton;
    protected ImageButton removePageLeftButton;
    protected ImageButton insertEmptyPageRightButton;
    protected ImageButton removePageRightButton;
    protected ImageButton exportBookButton;
    protected ImageButton importBookButton;
    protected boolean bookModified;

    public SpreadBookEditScreen(ItemStack bookStack, InteractionHand hand) {
        super(BookColor.of(bookStack));
        this.bookStack = bookStack;
        this.hand = hand;
    }

    public History getHistory() {
        return this.history;
    }

    protected void setupPages(ItemStack bookStack) {
        this.pages.clear();
        CompoundTag compoundtag = bookStack.m_41783_();
        if (compoundtag != null) {
            BookViewScreen.m_169696_((CompoundTag)compoundtag, this.pages::add);
        }
        while (this.pages.size() < 2) {
            this.pages.add("");
        }
        this.setTextBoxes(false);
    }

    @Override
    protected void createWidgets() {
        this.leftPageTextBox = new TextBox(this.f_96547_, this.leftPos + 22, this.topPos + 21, 114, 128).setFontColor(this.textColor).setFontUnfocusedColor(this.textColor).setSelectionColor(this.selectionColor).setSelectionUnfocusedColor(this.selectionUnfocusedColor).setText(FormattedString.parse(this.getPageText(Spread.Side.LEFT))).setOnTextChanged(text -> this.setPageText(Spread.Side.LEFT, text.toString()));
        this.m_142416_((GuiEventListener)this.leftPageTextBox);
        this.rightPageTextBox = new TextBox(this.f_96547_, this.leftPos + 159, this.topPos + 21, 114, 128).setFontColor(this.textColor).setFontUnfocusedColor(this.textColor).setSelectionColor(this.selectionColor).setSelectionUnfocusedColor(this.selectionUnfocusedColor).setText(FormattedString.parse(this.getPageText(Spread.Side.RIGHT))).setOnTextChanged(text -> this.setPageText(Spread.Side.RIGHT, text.toString()));
        this.m_142416_((GuiEventListener)this.rightPageTextBox);
        this.setupPages(this.bookStack);
        this.createPageToolButtons();
        this.createPrevPageButton();
        this.createNextPageButton();
        this.createImportExportButtons();
        ImageButton enterSignModeButton = new ImageButton(this.leftPos - 24, this.topPos + 18, 22, 22, 321, 0, 22, TEXTURE, 512, 512, b -> this.enterSignMode(), (Component)Component.m_237115_((String)"book.signButton"));
        enterSignModeButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"book.signButton")));
        this.m_142416_((GuiEventListener)enterSignModeButton);
        this.createBottomButtons();
    }

    protected void createPageToolButtons() {
        this.insertEmptyPageLeftButton = new ImageButton(this.leftPos + 112, this.topPos + 154, 13, 13, 343, 0, 13, TEXTURE, 512, 512, b -> this.insertEmptyPage(Spread.Side.LEFT), (Component)Component.m_237115_((String)"gui.scholar.insert_empty_page"));
        this.insertEmptyPageLeftButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.scholar.insert_empty_page").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.scholar.insert_empty_page_left.hotkey"))));
        this.m_142416_((GuiEventListener)this.insertEmptyPageLeftButton);
        this.removePageLeftButton = new ImageButton(this.leftPos + 126, this.topPos + 154, 13, 13, 356, 0, 13, TEXTURE, 512, 512, b -> this.removePage(Spread.Side.LEFT), (Component)Component.m_237115_((String)"gui.scholar.remove_page"));
        this.removePageLeftButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.scholar.remove_page").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.scholar.remove_page_left.hotkey"))));
        this.m_142416_((GuiEventListener)this.removePageLeftButton);
        this.insertEmptyPageRightButton = new ImageButton(this.leftPos + 156, this.topPos + 154, 13, 13, 343, 0, 13, TEXTURE, 512, 512, b -> this.insertEmptyPage(Spread.Side.RIGHT), (Component)Component.m_237115_((String)"gui.scholar.insert_empty_page"));
        this.insertEmptyPageRightButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.scholar.insert_empty_page").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.scholar.insert_empty_page_right.hotkey"))));
        this.m_142416_((GuiEventListener)this.insertEmptyPageRightButton);
        this.removePageRightButton = new ImageButton(this.leftPos + 170, this.topPos + 154, 13, 13, 356, 0, 13, TEXTURE, 512, 512, b -> this.removePage(Spread.Side.RIGHT), (Component)Component.m_237115_((String)"gui.scholar.remove_page"));
        this.removePageRightButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.scholar.remove_page").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.scholar.remove_page_right.hotkey"))));
        this.m_142416_((GuiEventListener)this.removePageRightButton);
    }

    protected void createImportExportButtons() {
        this.importBookButton = new ImageButton(this.leftPos + 297, this.topPos + 16, 18, 18, 387, 0, 18, TEXTURE, 512, 512, b -> this.importBook(Screen.m_96638_()), (Component)Component.m_237115_((String)"gui.scholar.import_book"));
        this.importBookButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.scholar.import_book").m_7220_((Component)ScholarClient.KeyMappings.componentForTooltip(ScholarClient.KeyMappings.importBook)).m_7220_(CommonComponents.f_178388_).m_7220_((Component)Component.m_237115_((String)"gui.scholar.import_book.tooltip"))));
        this.m_142416_((GuiEventListener)this.importBookButton);
        this.exportBookButton = new ImageButton(this.leftPos + 297, this.topPos + 41, 18, 18, 369, 0, 18, TEXTURE, 512, 512, b -> this.exportBook(Screen.m_96638_()), (Component)Component.m_237115_((String)"gui.scholar.export_book"));
        this.exportBookButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.scholar.export_book").m_7220_((Component)ScholarClient.KeyMappings.componentForTooltip(ScholarClient.KeyMappings.exportBook)).m_7220_(CommonComponents.f_178388_).m_7220_((Component)Component.m_237115_((String)"gui.scholar.export_book.tooltip"))));
        this.m_142416_((GuiEventListener)this.exportBookButton);
    }

    @Override
    protected void toggleBookTools() {
        super.toggleBookTools();
        this.playButtonClickSound();
    }

    @Override
    protected void updateButtonVisibility() {
        super.updateButtonVisibility();
        this.insertEmptyPageLeftButton.f_93624_ = this.isToolsVisible();
        this.insertEmptyPageLeftButton.f_93623_ = this.canInsertEmptyPage(Spread.Side.LEFT);
        this.insertEmptyPageRightButton.f_93624_ = this.isToolsVisible();
        this.insertEmptyPageRightButton.f_93623_ = this.canInsertEmptyPage(Spread.Side.RIGHT);
        this.removePageLeftButton.f_93624_ = this.isToolsVisible();
        this.removePageLeftButton.f_93623_ = this.canRemovePage(Spread.Side.LEFT);
        this.removePageRightButton.f_93624_ = this.isToolsVisible();
        this.removePageRightButton.f_93623_ = this.canRemovePage(Spread.Side.RIGHT);
        this.exportBookButton.f_93624_ = this.isToolsVisible();
        this.exportBookButton.f_93623_ = this.pages.stream().anyMatch(p -> !p.isEmpty());
        this.importBookButton.f_93624_ = this.isToolsVisible();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateButtonVisibility();
        this.m_280273_(guiGraphics);
        this.renderBook(guiGraphics, mouseX, mouseY, partialTick);
        this.renderPageNumbers(guiGraphics, mouseX, mouseY, partialTick, this.currentSpread);
        this.renderTools(guiGraphics, mouseX, mouseY, partialTick);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderBook(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtil.withColorMultiplied(this.bookColor, () -> {
            if (this.isToolsVisible()) {
                guiGraphics.m_280163_(TEXTURE, this.leftPos + 295, this.topPos + 14, 0.0f, 388.0f, 23, 48, 512, 512);
            }
            guiGraphics.m_280411_(TEXTURE, (this.f_96543_ - 295) / 2, (this.f_96544_ - 180) / 2, 295, 180, 0.0f, 0.0f, 295, 180, 512, 512);
            guiGraphics.m_280163_(TEXTURE, this.leftPos - 29, this.topPos + 14, 0.0f, 360.0f, 29, 28, 512, 512);
        });
        guiGraphics.m_280411_(TEXTURE, (this.f_96543_ - 295) / 2, (this.f_96544_ - 180) / 2, 295, 180, 0.0f, 180.0f, 295, 180, 512, 512);
    }

    @Override
    protected void renderTools(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = this.f_96543_ - 12;
        int y = 6;
        guiGraphics.m_280488_(this.f_96547_, "?", x, y, -5592406);
        if (mouseX >= x - 3 && mouseX < x + 12 + 3 && mouseY >= y - 3 && mouseY < y + 12) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237115_((String)"gui.scholar.tools.toggle").m_7220_((Component)ScholarClient.KeyMappings.componentForTooltip(ScholarClient.KeyMappings.toggleBookTools)));
            tooltip.add(Component.m_237115_((String)"gui.scholar.tools.tooltip.copy_with_formatting"));
            tooltip.add(Component.m_237115_((String)"gui.scholar.tools.tooltip.paste_with_formatting"));
            tooltip.add(Component.m_237115_((String)"gui.scholar.tools.tooltip.undo"));
            tooltip.add(Component.m_237115_((String)"gui.scholar.tools.tooltip.redo"));
            guiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY + 20);
        }
    }

    @Override
    public boolean m_7933_(int key, int scanCode, int modifiers) {
        TextBox textBox;
        if (ScholarClient.KeyMappings.importBook.m_90832_(key, scanCode)) {
            this.playButtonClickSound();
            this.importBook(Screen.m_96638_());
            return true;
        }
        if (ScholarClient.KeyMappings.exportBook.m_90832_(key, scanCode)) {
            this.playButtonClickSound();
            this.exportBook(Screen.m_96638_());
            return true;
        }
        if (Screen.m_96637_() && key == 90 && !Screen.m_96639_()) {
            Change change;
            float pitch = Screen.m_96638_() ? ((change = this.getHistory().redo()) == null ? 1.4f : 0.8f) : ((change = this.getHistory().undo()) == null ? 1.8f : 0.95f);
            this.playButtonClickSound(pitch);
            return true;
        }
        GuiEventListener pitch = this.m_7222_();
        if (!(pitch instanceof TextBox && (textBox = (TextBox)pitch).getEditor().isSelecting() || key != 67 || !Screen.m_96637_() || Screen.m_96639_())) {
            String bookContents = this.getBookContents(Screen.m_96638_());
            Minecraft.m_91087_().f_91068_.m_90911_(bookContents);
            return true;
        }
        if (Screen.m_96637_() && Screen.m_96638_() && key == 260) {
            this.insertEmptyPage(Screen.m_96639_() ? Spread.Side.RIGHT : Spread.Side.LEFT);
            return true;
        }
        if (Screen.m_96637_() && Screen.m_96638_() && key == 261) {
            this.removePage(Screen.m_96639_() ? Spread.Side.RIGHT : Spread.Side.LEFT);
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int x = this.f_96543_ - 12;
        int y = 6;
        if (mouseX >= (double)(x - 3) && mouseX < (double)(x + 12 + 3) && mouseY >= (double)(y - 3) && mouseY < (double)(y + 12)) {
            this.toggleBookTools();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    protected boolean pageForward() {
        if (super.pageForward()) {
            while (this.pages.size() < (this.currentSpread + 1) * 2) {
                this.appendEmptyPage();
            }
            this.setTextBoxes();
            this.getHistory().add(() -> {
                super.pageForward();
                this.setTextBoxes();
            }, () -> {
                super.pageBack();
                this.setTextBoxes();
            });
            return true;
        }
        return false;
    }

    @Override
    protected boolean pageBack() {
        if (super.pageBack()) {
            this.setTextBoxes();
            this.getHistory().add(() -> {
                super.pageBack();
                this.setTextBoxes();
            }, () -> {
                super.pageForward();
                this.setTextBoxes();
            });
            return true;
        }
        return false;
    }

    protected void setTextBoxes() {
        this.setTextBoxes(true);
    }

    protected void setTextBoxes(boolean resetCursor) {
        FormattedString leftString = FormattedString.parse(this.getPageText(Spread.Side.LEFT));
        if (!leftString.equals(this.leftPageTextBox.getEditor().getString())) {
            this.leftPageTextBox.getEditor().setString(leftString);
            int leftCursorPos = resetCursor ? 0 : this.leftPageTextBox.getEditor().getCursorPos();
            this.leftPageTextBox.getEditor().setCursorPos(leftCursorPos, false);
        }
        this.leftPageTextBox.getDisplayCache().scheduleUpdate();
        FormattedString rightString = FormattedString.parse(this.getPageText(Spread.Side.RIGHT));
        if (!rightString.equals(this.rightPageTextBox.getEditor().getString())) {
            this.rightPageTextBox.getEditor().setString(rightString);
            int rightCursorPos = resetCursor ? 0 : this.rightPageTextBox.getEditor().getCursorPos();
            this.rightPageTextBox.getEditor().setCursorPos(rightCursorPos, false);
        }
        this.rightPageTextBox.getDisplayCache().scheduleUpdate();
    }

    protected void enterSignMode() {
        this.saveChanges(false, null);
        this.minecraft.execute(() -> this.minecraft.m_91152_((Screen)new BookSigningScreen(this, this.bookColor, title -> this.saveChanges(true, (String)title))));
    }

    protected String getPageText(Spread.Side side) {
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        return pageIndex >= 0 && pageIndex < this.pages.size() ? this.pages.get(pageIndex) : "";
    }

    protected void setPageText(Spread.Side side, String text) {
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        while (pageIndex > this.pages.size() - 1 && pageIndex < this.getPageCount()) {
            this.appendEmptyPage();
        }
        if (pageIndex >= 0 && pageIndex < this.pages.size()) {
            String currentText = this.getPageText(side);
            this.getHistory().add(() -> {
                this.pages.set(pageIndex, text);
                this.bookModified = true;
                this.setTextBoxes(false);
            }, () -> {
                this.pages.set(pageIndex, currentText);
                this.bookModified = true;
                this.setTextBoxes(false);
            });
            this.pages.set(pageIndex, text);
            this.bookModified = true;
        }
    }

    protected void appendEmptyPage() {
        if (this.pages.size() < 100) {
            this.pages.add("");
        }
    }

    protected void insertEmptyPage(Spread.Side side) {
        if (!this.canInsertEmptyPage(side)) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_5661_((Component)Component.m_237115_((String)"gui.scholar.cannot_insert_page"), false);
            return;
        }
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        Change change = Change.create(() -> {
            this.pages.add(pageIndex, "");
            while (this.pages.size() >= 100) {
                this.pages.remove(this.pages.size() - 1);
            }
            this.setTextBoxes();
            this.bookModified = true;
            this.playPageTurnSound(1.0f, 0.6f);
        }, () -> {
            this.pages.remove(pageIndex);
            this.setTextBoxes();
            this.bookModified = true;
            this.playPageTurnSound(1.0f, 0.8f);
        });
        change.apply();
        this.getHistory().add(change);
    }

    protected void removePage(Spread.Side side) {
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        String pageContent = this.pages.get(pageIndex);
        Change change = Change.create(() -> {
            this.pages.remove(pageIndex);
            while (this.pages.size() < Spread.Side.RIGHT.getPageIndexFromSpread(this.currentSpread) + 1) {
                this.pages.add("");
            }
            this.setTextBoxes();
            this.bookModified = true;
            this.playPageTurnSound(0.85f, 0.6f);
        }, () -> {
            this.pages.add(pageIndex, pageContent);
            this.setTextBoxes();
            this.bookModified = true;
            this.playPageTurnSound(0.85f, 0.8f);
        });
        change.apply();
        this.getHistory().add(change);
    }

    protected void saveChanges(boolean sign, @Nullable String title) {
        if (this.bookModified || sign) {
            if (!sign) {
                title = null;
            }
            this.removeEmptyTrailingPages();
            this.updateLocalCopy(sign, title);
            this.sendChanges(title);
        }
    }

    protected void sendChanges(@Nullable String title) {
        int slotId = this.hand == InteractionHand.MAIN_HAND ? this.player.m_150109_().f_35977_ : 40;
        Objects.requireNonNull(this.minecraft.m_91403_()).m_104955_((Packet)new ServerboundEditBookPacket(slotId, this.pages, Optional.ofNullable(title)));
    }

    protected void removeEmptyTrailingPages() {
        ListIterator<String> iterator = this.pages.listIterator(this.pages.size());
        while (iterator.hasPrevious() && iterator.previous().isEmpty()) {
            iterator.remove();
        }
    }

    protected void updateLocalCopy(boolean sign, @Nullable String title) {
        ListTag listTag = new ListTag();
        this.pages.stream().map(StringTag::m_129297_).forEach(arg_0 -> listTag.add(arg_0));
        if (!this.pages.isEmpty()) {
            this.bookStack.m_41700_("pages", (Tag)listTag);
        }
        if (sign) {
            Preconditions.checkState((!StringUtil.isNullOrEmpty((String)title) ? 1 : 0) != 0, (Object)"Title cannot be null or empty when signing a book.");
            this.bookStack.m_41700_("author", (Tag)StringTag.m_129297_((String)this.player.m_36316_().getName()));
            this.bookStack.m_41700_("title", (Tag)StringTag.m_129297_((String)title));
        }
    }

    protected boolean canInsertEmptyPage(Spread.Side side) {
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        int lastPageWithContent = this.getLastPageWithContent().orElse(-1);
        return lastPageWithContent < 99 && pageIndex <= lastPageWithContent;
    }

    protected boolean canRemovePage(Spread.Side side) {
        return this.containsContentAfter(side.getPageIndexFromSpread(this.currentSpread));
    }

    protected OptionalInt getLastPageWithContent() {
        for (int i = this.pages.size() - 1; i >= 0; --i) {
            if (this.pages.get(i).isEmpty()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    protected boolean containsContentAfter(int pageIndex) {
        return this.pages.stream().skip(pageIndex).anyMatch(p -> !p.isEmpty());
    }

    public String getBookContents(boolean withFormatting) {
        String contents = String.join((CharSequence)"\n", this.pages);
        if (!withFormatting) {
            ChatFormatting.m_126649_((String)contents);
        }
        return contents;
    }

    public void setBookContents(String contents, boolean withFormatting) {
        ArrayList<String> oldPages = new ArrayList<String>(this.pages);
        this.pages.clear();
        contents = contents.replaceAll("\\r", "");
        if (!withFormatting) {
            contents = ChatFormatting.m_126649_((String)contents);
            assert (contents != null);
        }
        String[] pages = contents.split("\f");
        Predicate<String> validator = FormattedStringEditor.Validator.fitInDimensions(this.f_96547_, this.leftPageTextBox.m_5711_(), this.leftPageTextBox.m_93694_());
        for (String pageContent : pages) {
            if (pageContent.isEmpty()) {
                this.pages.add("");
                continue;
            }
            FormattedString string = FormattedString.parse(pageContent);
            int currentChar = 0;
            FormattedString currentString = new FormattedString();
            String lastValidString = "";
            while (currentChar < string.length()) {
                currentString.add((Char)string.get(currentChar));
                ++currentChar;
                String str = currentString.toString();
                if (!validator.test(str)) {
                    this.pages.add(lastValidString);
                    if (this.pages.size() >= 100) {
                        lastValidString = "";
                        break;
                    }
                    --currentChar;
                    currentString.clear();
                    continue;
                }
                lastValidString = str;
            }
            if (lastValidString.isEmpty() || this.pages.size() > 100) continue;
            this.pages.add(lastValidString);
        }
        this.bookModified = true;
        this.setTextBoxes();
        ArrayList<String> newPages = new ArrayList<String>(this.pages);
        this.getHistory().add(() -> {
            this.pages.clear();
            this.pages.addAll(newPages);
            this.bookModified = true;
            this.setTextBoxes();
        }, () -> {
            this.pages.clear();
            this.pages.addAll(oldPages);
            this.bookModified = true;
            this.setTextBoxes();
        });
    }

    public void importBook(boolean withFormatting) {
        CompletableFuture.runAsync(() -> {
            Object defaultDirectory = Minecraft.m_91087_().f_91069_.toPath().toAbsolutePath().normalize().toString();
            if (!((String)defaultDirectory).endsWith(File.separator)) {
                defaultDirectory = (String)defaultDirectory + File.separator;
            }
            String title = Component.m_237115_((String)"gui.scholar.import_book").getString();
            FileDialogs.loadFile((String)defaultDirectory, title, "Text Files (.txt)", false, "*.txt").ifPresent(filePath -> {
                try {
                    String content = Files.readString(Path.of(filePath, new String[0]));
                    Minecraft.m_91087_().execute(() -> this.setBookContents(content, withFormatting));
                }
                catch (IOException e) {
                    Minecraft.m_91087_().execute(() -> this.player.m_5661_((Component)Component.m_237115_((String)"gui.scholar.import_book.failure"), false));
                    Scholar.LOGGER.error("Failed to import book: ", (Throwable)e);
                }
            });
        }).exceptionally(e -> {
            Minecraft.m_91087_().execute(() -> this.player.m_5661_((Component)Component.m_237115_((String)"gui.scholar.import_book.failure"), false));
            Scholar.LOGGER.error("Failed to import book: ", e);
            return null;
        });
    }

    public void exportBook(boolean withFormatting) {
        String content;
        String string = content = withFormatting ? String.join((CharSequence)"\f", this.pages) : ChatFormatting.m_126649_((String)String.join((CharSequence)"\f", this.pages));
        assert (content != null);
        CompletableFuture.runAsync(() -> {
            Object defaultDirectory = Minecraft.m_91087_().f_91069_.toPath().toAbsolutePath().normalize().toString();
            if (!((String)defaultDirectory).endsWith(File.separator)) {
                defaultDirectory = (String)defaultDirectory + File.separator;
            }
            String title = Component.m_237115_((String)"gui.scholar.export_book").getString();
            FileDialogs.saveFile((String)defaultDirectory, title, "Text Files (.txt)", "*.txt").ifPresent(filePath -> {
                try {
                    Files.writeString(Path.of(filePath, new String[0]), (CharSequence)content, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    MutableComponent filePathComponent = Component.m_237113_((String)filePath).m_130948_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, filePath)));
                    Minecraft.m_91087_().execute(() -> this.player.m_5661_((Component)Component.m_237115_((String)"gui.scholar.export_book.success").m_7220_((Component)filePathComponent), false));
                }
                catch (IOException e) {
                    Minecraft.m_91087_().execute(() -> this.player.m_5661_((Component)Component.m_237115_((String)"gui.scholar.export_book.failure"), false));
                    Scholar.LOGGER.error("Failed to export book: ", (Throwable)e);
                }
            });
        }).exceptionally(e -> {
            Minecraft.m_91087_().execute(() -> this.player.m_5661_((Component)Component.m_237115_((String)"gui.scholar.export_book.failure"), false));
            Scholar.LOGGER.error("Failed to export book: ", e);
            return null;
        });
    }

    public void m_7379_() {
        this.saveChanges(false, null);
        super.m_7379_();
    }
}

