/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei;

import io.bluebeaker.mteenoughitems.MTEEnoughItems;
import io.bluebeaker.mteenoughitems.jei.plugins.BCSiliconPlugin;
import io.bluebeaker.mteenoughitems.jei.plugins.ForestryPlugin;
import io.bluebeaker.mteenoughitems.jei.plugins.IPlugin;
import io.bluebeaker.mteenoughitems.jei.plugins.RailcraftPlugin;
import io.bluebeaker.mteenoughitems.jei.plugins.StorageDrawersPlugin;
import io.bluebeaker.mteenoughitems.jei.plugins.ThermalExpansionPlugin;
import io.bluebeaker.mteenoughitems.jei.plugins.ThermalFoundationPlugin;
import io.bluebeaker.mteenoughitems.utils.LogTimer;
import io.bluebeaker.mteenoughitems.utils.ModChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;

@JEIPlugin
public class MTEEIPlugin
implements IModPlugin {
    private static IJeiRuntime jeiRuntime = null;
    public static IModRegistry modRegistry;
    public final List<IPlugin> plugins = new ArrayList<IPlugin>();

    public MTEEIPlugin() {
        for (Plugins entry : Plugins.values()) {
            if (!entry.modChecker.isLoaded()) continue;
            try {
                this.plugins.add((IPlugin)entry.supplier.get());
            }
            catch (Exception e) {
                MTEEnoughItems.getLogger().error("Error init plugin for mod {}:", (Object)((Plugins)entry).modChecker.name, (Object)e);
            }
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        for (IPlugin plugin : this.plugins) {
            try {
                plugin.registerCategories(registry);
            }
            catch (Throwable e) {
                MTEEnoughItems.getLogger().error("Error registering categories for {}:", (Object)plugin.getName(), (Object)e);
            }
        }
    }

    public void register(IModRegistry registry) {
        modRegistry = registry;
        LogTimer timer = new LogTimer();
        MTEEnoughItems.getLogger().info("Started loading recipes...");
        for (IPlugin plugin : this.plugins) {
            try {
                plugin.register(registry);
                MTEEnoughItems.getLogger().info("Loaded {} recipes in {}ms", (Object)plugin.getName(), (Object)timer.stagedTime());
            }
            catch (Throwable e) {
                MTEEnoughItems.getLogger().error("Error loading recipes for {}:", (Object)plugin.getName(), (Object)e);
                timer.stagedTime();
            }
        }
    }

    public void registerSubtypes(ISubtypeRegistry subtypeRegistry) {
        for (IPlugin plugin : this.plugins) {
            try {
                plugin.registerSubtypes(subtypeRegistry);
            }
            catch (Throwable e) {
                MTEEnoughItems.getLogger().error("Error registering subtypes for {}:", (Object)plugin.getName(), (Object)e);
            }
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntimeIn) {
        jeiRuntime = jeiRuntimeIn;
    }

    public static enum Plugins {
        Forestry(ModChecker.Forestry, ForestryPlugin::new),
        Railcraft(ModChecker.Railcraft, RailcraftPlugin::new),
        BuildcraftSilicon(ModChecker.BuildcraftSilicon, BCSiliconPlugin::new),
        StorageDrawers(ModChecker.StorageDrawers, StorageDrawersPlugin::new),
        ThermalFoundation(ModChecker.ThermalFoundation, ThermalFoundationPlugin::new),
        ThermalExpansion(ModChecker.ThermalExpansion, ThermalExpansionPlugin::new);

        private final ModChecker modChecker;
        private final Supplier<IPlugin> supplier;

        private Plugins(ModChecker modChecker, Supplier<IPlugin> supplier) {
            this.modChecker = modChecker;
            this.supplier = supplier;
        }
    }
}

