/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.buildcraft;

import buildcraft.api.BCItems;
import buildcraft.api.mj.MjAPI;
import buildcraft.silicon.BCSiliconBlocks;
import buildcraft.silicon.plug.FacadeBlockStateInfo;
import buildcraft.silicon.plug.FacadeStateManager;
import buildcraft.silicon.recipe.FacadeAssemblyRecipes;
import io.bluebeaker.mteenoughitems.jei.generic.GenericRecipeCategory;
import io.bluebeaker.mteenoughitems.utils.ModChecker;
import io.bluebeaker.mteenoughitems.utils.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FacadeAssemblyCategory
extends GenericRecipeCategory<Wrapper> {
    public static final String UID = "mteenoughitems.buildcraft.facade_assembly";
    protected static final ResourceLocation backgroundLocation = new ResourceLocation("buildcraftsilicon", "textures/gui/assembly_table.png");
    private final IDrawable background;
    private final IDrawable progressBar;
    private static ItemStack baseRequirementStack = null;

    public FacadeAssemblyCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.background = guiHelper.drawableBuilder(backgroundLocation, 5, 34, 166, 76).addPadding(10, 0, 0, 0).build();
        this.progressBar = guiHelper.drawableBuilder(backgroundLocation, 176, 48, 4, 71).addPadding(10, 0, 0, 0).buildAnimated(10, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((Block)BCSiliconBlocks.assemblyTable));
    }

    @Override
    public String getTranslationKey() {
        return "category.mteenoughitems.buildcraft.facade_assembly.name";
    }

    public String getUid() {
        return UID;
    }

    public String getModName() {
        return ModChecker.BuildcraftSilicon.name;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.progressBar.draw(minecraft, 81, 2);
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, Wrapper wrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        for (int i = 0; i < inputs.size(); ++i) {
            guiItemStacks.init(i, true, 2 + i % 3 * 18, 11 + i / 3 * 18);
            guiItemStacks.set(i, (List)inputs.get(i));
        }
        guiItemStacks.init(12, false, 110, 11);
        guiItemStacks.set(12, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public static List<Wrapper> getRecipes() {
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        for (FacadeBlockStateInfo info : FacadeStateManager.validFacadeStates.values()) {
            if (!info.isVisible) continue;
            recipes.add(new Wrapper(FacadeAssemblyCategory.getInputsFor(info), FacadeAssemblyRecipes.createFacadeStack((FacadeBlockStateInfo)info, (boolean)false), 64L * MjAPI.MJ));
            recipes.add(new Wrapper(FacadeAssemblyCategory.getInputsFor(info), FacadeAssemblyRecipes.createFacadeStack((FacadeBlockStateInfo)info, (boolean)true), 64L * MjAPI.MJ));
        }
        return recipes;
    }

    public static List<ItemStack> getInputsFor(FacadeBlockStateInfo info) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(info.requiredStack);
        if (baseRequirementStack == null) {
            baseRequirementStack = BCItems.Transport.PIPE_STRUCTURE == null ? new ItemStack(Blocks.field_150463_bK) : new ItemStack(BCItems.Transport.PIPE_STRUCTURE, 3);
        }
        stacks.add(baseRequirementStack);
        return stacks;
    }

    public static class Wrapper
    implements IRecipeWrapper {
        public final List<ItemStack> inputs;
        public final ItemStack output;
        public final long energy;

        public Wrapper(List<ItemStack> inputs, ItemStack output, long energy) {
            this.inputs = inputs;
            this.output = output;
            this.energy = energy;
        }

        public void getIngredients(IIngredients ingredients) {
            ArrayList inputIngredients = new ArrayList();
            ingredients.setInputs(VanillaTypes.ITEM, this.inputs);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }

        @SideOnly(value=Side.CLIENT)
        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            RenderUtils.drawTextAlignedLeft(MjAPI.formatMj((long)this.energy) + " MJ", 4, 0, Color.gray.getRGB());
        }
    }
}

