/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.forestry;

import com.google.common.collect.HashMultimap;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IFlowerRegistry;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.flowers.Flower;
import forestry.apiculture.flowers.FlowerProvider;
import forestry.apiculture.flowers.FlowerRegistry;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.utils.BlockStateSet;
import io.bluebeaker.mteenoughitems.MTEEnoughItems;
import io.bluebeaker.mteenoughitems.jei.forestry.accessors.FlowerAccessor;
import io.bluebeaker.mteenoughitems.jei.generic.GenericRecipeCategory;
import io.bluebeaker.mteenoughitems.jei.utils.BlockTooltipCallbacks;
import io.bluebeaker.mteenoughitems.utils.BlockDropChecker;
import io.bluebeaker.mteenoughitems.utils.ModChecker;
import io.bluebeaker.mteenoughitems.utils.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BeekeepingFlowersCategory
extends GenericRecipeCategory<Wrapper> {
    public static final String UID = "mteenoughitems.forestry.beekeeping_flowers";
    public static final int MARGIN_X = 4;

    public BeekeepingFlowersCategory(IGuiHelper guiHelper) {
        super(guiHelper, 170, 120);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((Block)Blocks.field_150327_N));
    }

    public String getModName() {
        return ModChecker.Forestry.name;
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, Wrapper wrapper, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
        BlockTooltipCallbacks callbacks = new BlockTooltipCallbacks();
        this.addItemSlot(guiItemStackGroup, 45, 4, 4);
        guiItemStackGroup.set(45, wrapper.bees);
        for (int i = 0; i < wrapper.items.size(); ++i) {
            this.addItemSlot(guiItemStackGroup, i, 4 + 18 * (i % 9), 26 + 18 * (i / 9));
            guiItemStackGroup.set(i, wrapper.items.get(i));
            callbacks.add(i, wrapper.getFlowerDefs().get((int)i).blockState);
        }
        guiItemStackGroup.addTooltipCallback((ITooltipCallback)new TooltipCallback(wrapper, callbacks.getItemCallback()));
    }

    @Override
    public String getTranslationKey() {
        return "category.mteenoughitems.forestry.beekeeping_flowers.name";
    }

    public String getUid() {
        return UID;
    }

    public static List<Wrapper> getRecipes(IJeiHelpers jeiHelpers) {
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        IFlowerRegistry flowerRegistry = FlowerManager.flowerRegistry;
        if (!(flowerRegistry instanceof FlowerRegistry)) {
            return recipes;
        }
        FlowerRegistry flowerRegistry1 = (FlowerRegistry)flowerRegistry;
        HashMultimap<String, Block> blocks = FlowerAccessor.acceptableBlocks.get(flowerRegistry1);
        Map<String, BlockStateSet> blockstates = FlowerAccessor.acceptableBlockStates.get(flowerRegistry1);
        HashMultimap<String, Flower> plantableFlowers = FlowerAccessor.plantableFlowers.get(flowerRegistry1);
        if (blocks == null || blockstates == null || plantableFlowers == null) {
            MTEEnoughItems.getLogger().warn("Failed to access FlowerRegistry, not loading flowers");
            return recipes;
        }
        HashMap<String, FlowerProvider> flowerTypes = new HashMap<String, FlowerProvider>();
        for (EnumAllele.Flowers value : EnumAllele.Flowers.values()) {
            flowerTypes.put(value.getValue().getFlowerType(), value.getValue());
        }
        blocks.keySet().forEach(s -> {
            if (!flowerTypes.containsKey(s)) {
                flowerTypes.put((String)s, new FlowerProvider(s, s));
            }
        });
        blockstates.keySet().forEach(s -> {
            if (!flowerTypes.containsKey(s)) {
                flowerTypes.put((String)s, new FlowerProvider(s, s));
            }
        });
        plantableFlowers.keySet().forEach(s -> {
            if (!flowerTypes.containsKey(s)) {
                flowerTypes.put((String)s, new FlowerProvider(s, s));
            }
        });
        HashMap<String, List<ItemStack>> flowersToBees = new HashMap<String, List<ItemStack>>();
        BeekeepingFlowersCategory.addFlowersToBees(flowersToBees);
        for (String flowerType : flowerTypes.keySet()) {
            Object block2;
            HashSet<IBlockState> states = new HashSet<IBlockState>();
            BlockStateSet iBlockStates = blockstates.get(flowerType);
            if (iBlockStates != null) {
                states.addAll((Collection<IBlockState>)iBlockStates);
            }
            for (Object block2 : blocks.get((Object)flowerType)) {
                states.add(block2.func_176223_P());
            }
            HashSet<IBlockState> plantable = new HashSet<IBlockState>();
            block2 = plantableFlowers.get((Object)flowerType).iterator();
            while (block2.hasNext()) {
                Flower flower = (Flower)block2.next();
                plantable.add(flower.getBlockState());
            }
            ArrayList<FlowerDef> flowerDefs = new ArrayList<FlowerDef>();
            for (IBlockState state : states) {
                flowerDefs.add(new FlowerDef(state, plantable.contains(state)));
            }
            flowerDefs.sort(Comparator.comparing(f -> f.blockState.toString()));
            for (int i = 0; i < flowerDefs.size(); i += 45) {
                List<FlowerDef> subList = flowerDefs.subList(i, Math.min(i + 45, flowerDefs.size()));
                recipes.add(new Wrapper((FlowerProvider)flowerTypes.get(flowerType), subList, (List)flowersToBees.get(flowerType)));
            }
        }
        return recipes;
    }

    private static void addFlowersToBees(Map<String, List<ItemStack>> flowersToBees) {
        if (BeeManager.beeRoot == null) {
            return;
        }
        List individualTemplates = BeeManager.beeRoot.getIndividualTemplates();
        for (IBee individual : individualTemplates) {
            individual.analyze();
            String flowerType = individual.getGenome().getFlowerProvider().getFlowerType();
            flowersToBees.computeIfAbsent(flowerType, type -> new ArrayList());
            NBTTagCompound nbt = new NBTTagCompound();
            individual.writeToNBT(nbt);
            ItemStack princess = new ItemStack((Item)ModuleApiculture.getItems().beePrincessGE);
            ItemStack drone = new ItemStack((Item)ModuleApiculture.getItems().beeDroneGE);
            princess.func_77982_d(nbt);
            drone.func_77982_d(nbt);
            individual.mate((IIndividual)individual);
            ItemStack queen = new ItemStack((Item)ModuleApiculture.getItems().beeQueenGE);
            nbt = new NBTTagCompound();
            individual.writeToNBT(nbt);
            queen.func_77982_d(nbt);
            flowersToBees.get(flowerType).add(queen);
            flowersToBees.get(flowerType).add(princess);
            flowersToBees.get(flowerType).add(drone);
        }
    }

    public static class Wrapper
    implements IRecipeWrapper {
        public final FlowerProvider provider;
        public final int size;
        public final List<FlowerDef> flowerDefs;
        public final List<ItemStack> items;
        public final List<ItemStack> bees;

        public Wrapper(FlowerProvider provider, List<FlowerDef> flowerDefs, List<ItemStack> bees) {
            this.provider = provider;
            this.flowerDefs = Collections.unmodifiableList(flowerDefs);
            this.size = flowerDefs.size();
            this.bees = bees;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(this.size);
            for (FlowerDef flowerDef : flowerDefs) {
                items.add(BlockDropChecker.getDrop(flowerDef.blockState));
            }
            this.items = Collections.unmodifiableList(items);
        }

        public void getIngredients(IIngredients iIngredients) {
            ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
            inputs.add(this.bees);
            for (ItemStack item : this.items) {
                inputs.add(Collections.singletonList(item));
            }
            iIngredients.setInputLists(VanillaTypes.ITEM, inputs);
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            for (int i = 0; i < this.items.size(); ++i) {
                if (!this.flowerDefs.get((int)i).plantable) continue;
                outputs.add(this.items.get(i));
            }
            iIngredients.setOutputs(VanillaTypes.ITEM, outputs);
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int xPos = 16;
            int yPos = 4;
            RenderUtils.drawTextAlignedMiddle(this.provider.getDescription(), recipeWidth / 2, yPos, Color.gray.getRGB());
        }

        public List<FlowerDef> getFlowerDefs() {
            return this.flowerDefs;
        }
    }

    public static class TooltipCallback
    implements ITooltipCallback<ItemStack> {
        private final Wrapper wrapper;
        private final ITooltipCallback<ItemStack> parent;

        public TooltipCallback(Wrapper wrapper, ITooltipCallback<ItemStack> parent) {
            this.wrapper = wrapper;
            this.parent = parent;
        }

        public void onTooltip(int i, boolean b, ItemStack stack, List<String> list) {
            this.parent.onTooltip(i, b, (Object)stack, list);
            if (i >= this.wrapper.size) {
                return;
            }
            if (this.wrapper.getFlowerDefs().get((int)i).plantable) {
                list.add(I18n.func_135052_a((String)"category.mteenoughitems.forestry.beekeeping_flowers.grow", (Object[])new Object[0]));
            }
        }
    }

    public static class FlowerDef {
        public final boolean plantable;
        public final IBlockState blockState;

        public FlowerDef(IBlockState blockState, boolean plantable) {
            this.plantable = plantable;
            this.blockState = blockState;
        }
    }
}

