/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.forestry;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.plugins.PluginIC2;
import io.bluebeaker.mteenoughitems.jei.generic.FluidPowerRecipeCategory;
import io.bluebeaker.mteenoughitems.jei.generic.FluidPowerRecipeWrapper;
import io.bluebeaker.mteenoughitems.utils.EnergyUnit;
import io.bluebeaker.mteenoughitems.utils.ModChecker;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class BioGeneratorCategory
extends FluidPowerRecipeCategory<BioGeneratorRecipeWrapper> {
    public static final String UID = "mteenoughitems.forestry.biogas_generator";

    public BioGeneratorCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((Block)PluginIC2.getBlocks().generator));
    }

    public String getModName() {
        return ModChecker.Forestry.name;
    }

    @Override
    public String getTranslationKey() {
        return "category.mteenoughitems.forestry.biogas_generator.name";
    }

    @Override
    public String getTitle() {
        return PluginIC2.getBlocks().generator.func_149732_F();
    }

    public String getUid() {
        return UID;
    }

    @Override
    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public static List<BioGeneratorRecipeWrapper> getRecipes(IJeiHelpers jeiHelpers) {
        ArrayList<BioGeneratorRecipeWrapper> recipes = new ArrayList<BioGeneratorRecipeWrapper>();
        for (Fluid fluid : FuelManager.generatorFuel.keySet()) {
            GeneratorFuel fuel = (GeneratorFuel)FuelManager.generatorFuel.get(fluid);
            recipes.add(new BioGeneratorRecipeWrapper(jeiHelpers, fluid, (long)fuel.getEu(), (long)fuel.getRate() * (long)fuel.getEu()));
        }
        return recipes;
    }

    public static class BioGeneratorRecipeWrapper
    extends FluidPowerRecipeWrapper {
        public BioGeneratorRecipeWrapper(IJeiHelpers jeiHelpers, Fluid fluid, long power, long energy) {
            super(jeiHelpers, fluid, power, energy);
        }

        @Override
        public String getPowerUnit() {
            return EnergyUnit.EU.name;
        }
    }
}

