/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.forestry;

import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import forestry.energy.ModuleEnergy;
import io.bluebeaker.mteenoughitems.jei.generic.FluidPowerRecipeCategory;
import io.bluebeaker.mteenoughitems.jei.generic.FluidPowerRecipeWrapper;
import io.bluebeaker.mteenoughitems.utils.EnergyUnit;
import io.bluebeaker.mteenoughitems.utils.ModChecker;
import io.bluebeaker.mteenoughitems.utils.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BiogasEngineCategory
extends FluidPowerRecipeCategory<BiogasEngineRecipeWrapper> {
    public static final String UID = "mteenoughitems.forestry.biogas_engine";
    public static final EnergyUnit ENERGY_UNIT = EnergyUnit.RF;
    public final int SLOT_Y;
    public static final ResourceLocation GUI_PATH = new ResourceLocation("forestry", "textures/gui/bioengine.png");
    protected final IDrawableStatic bgHeatBar;
    protected final IDrawableAnimated heatBar;

    public BiogasEngineCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.SLOT_Y = this.GUI_HEIGHT / 2 - 9;
        this.bgHeatBar = guiHelper.createDrawable(GUI_PATH, 53, 46, 4, 18);
        this.heatBar = guiHelper.drawableBuilder(GUI_PATH, 176, 60, 4, 16).buildAnimated(200, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((Block)ModuleEnergy.getBlocks().biogasEngine));
    }

    public String getModName() {
        return ModChecker.Forestry.name;
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
        this.bgHeatBar.draw(minecraft, 8, this.SLOT_Y);
        this.heatBar.draw(minecraft, 8, this.SLOT_Y + 1);
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, BiogasEngineRecipeWrapper wrapper, IIngredients iIngredients) {
        IGuiFluidStackGroup guiFluidStackGroup = recipeLayout.getFluidStacks();
        this.addFluidSlot(guiFluidStackGroup, 0, this.GUI_WIDTH - 44, this.SLOT_Y);
        guiFluidStackGroup.set(0, wrapper.getFluidStack());
        this.addFluidSlot(guiFluidStackGroup, 1, this.GUI_WIDTH - 26, this.SLOT_Y);
        guiFluidStackGroup.set(1, BiogasEngineRecipeWrapper.LAVA);
        guiFluidStackGroup.addTooltipCallback((ITooltipCallback)new TooltipCallback(wrapper));
    }

    @Override
    public String getTranslationKey() {
        return "category.mteenoughitems.forestry.biogas_engine.name";
    }

    @Override
    public String getTitle() {
        return ModuleEnergy.getBlocks().biogasEngine.func_149732_F();
    }

    public String getUid() {
        return UID;
    }

    public static List<BiogasEngineRecipeWrapper> getRecipes(IJeiHelpers jeiHelpers) {
        ArrayList<BiogasEngineRecipeWrapper> recipes = new ArrayList<BiogasEngineRecipeWrapper>();
        for (Fluid fluid : FuelManager.bronzeEngineFuel.keySet()) {
            EngineBronzeFuel fuel = (EngineBronzeFuel)FuelManager.bronzeEngineFuel.get(fluid);
            recipes.add(new BiogasEngineRecipeWrapper(jeiHelpers, fluid, fuel.getPowerPerCycle(), (long)fuel.getBurnDuration() * (long)fuel.getPowerPerCycle() / 1000L, fuel.getDissipationMultiplier()));
        }
        return recipes;
    }

    public static float getMinLoss(int dissipationMultiplier) {
        int maxHeatGain = 3 - dissipationMultiplier * 2;
        return maxHeatGain < 0 ? -20.0f / (float)maxHeatGain : 0.0f;
    }

    public static float getMaxLoss(int dissipationMultiplier) {
        int minHeatGain = 1 - dissipationMultiplier;
        return minHeatGain < 0 ? -20.0f / (float)minHeatGain : 0.0f;
    }

    public static class BiogasEngineRecipeWrapper
    extends FluidPowerRecipeWrapper {
        public static final FluidStack LAVA = new FluidStack(FluidRegistry.LAVA, 1000);
        public final int dissipationMultiplier;

        public BiogasEngineRecipeWrapper(IJeiHelpers jeiHelpers, Fluid fluid, long power, long energy, int dissipationMultiplier) {
            super(jeiHelpers, fluid, power, energy);
            this.dissipationMultiplier = dissipationMultiplier;
        }

        @Override
        public void getIngredients(IIngredients iIngredients) {
            ArrayList<FluidStack> inputs = new ArrayList<FluidStack>();
            inputs.add(this.fluidStack);
            inputs.add(LAVA);
            iIngredients.setInputs(VanillaTypes.FLUID, inputs);
        }

        @Override
        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int xPos = 16;
            int yPos = recipeHeight / 2 - minecraft.field_71466_p.field_78288_b;
            RenderUtils.drawTextAlignedLeft(this.power + this.getPowerUnit() + "/t", xPos, yPos, Color.gray.getRGB());
            RenderUtils.drawTextAlignedLeft(this.energy + this.getPowerUnit() + "/mB", xPos, yPos += minecraft.field_71466_p.field_78288_b + 2, Color.gray.getRGB());
            float minLoss = BiogasEngineCategory.getMinLoss(this.dissipationMultiplier);
            float maxLoss = BiogasEngineCategory.getMaxLoss(this.dissipationMultiplier);
            if (maxLoss > 0.0f || minLoss > 0.0f) {
                RenderUtils.drawTextAlignedLeft("!", recipeWidth - 7, recipeHeight / 2 - 8, Color.red.getRGB());
            }
        }
    }

    public static class TooltipCallback
    implements ITooltipCallback<FluidStack> {
        public final float minLoss;
        public final float maxLoss;

        public TooltipCallback(BiogasEngineRecipeWrapper wrapper) {
            this.minLoss = BiogasEngineCategory.getMinLoss(wrapper.dissipationMultiplier);
            this.maxLoss = BiogasEngineCategory.getMaxLoss(wrapper.dissipationMultiplier);
        }

        public void onTooltip(int i, boolean input, FluidStack fluidStack, List<String> list) {
            if (i != 1 || !input) {
                return;
            }
            if (this.minLoss > 0.0f || this.maxLoss > 0.0f) {
                list.add(I18n.func_135052_a((String)"category.mteenoughitems.forestry.biogas_engine.lava_constant", (Object[])new Object[0]));
            } else {
                list.add(I18n.func_135052_a((String)"category.mteenoughitems.forestry.biogas_engine.lava_startup", (Object[])new Object[0]));
            }
        }
    }
}

