/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.generic;

import io.bluebeaker.mteenoughitems.utils.EnergyUnit;
import io.bluebeaker.mteenoughitems.utils.RenderUtils;
import java.awt.Color;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidPowerRecipeWrapper
implements IRecipeWrapper {
    protected final IJeiHelpers jeiHelpers;
    protected final FluidStack fluidStack;
    public final long power;
    public final long energy;

    public FluidPowerRecipeWrapper(IJeiHelpers jeiHelpers, Fluid fluid, long power, long energy) {
        this(jeiHelpers, new FluidStack(fluid, 1000), power, energy);
    }

    public FluidPowerRecipeWrapper(IJeiHelpers jeiHelpers, FluidStack stack, long power, long energy) {
        this.jeiHelpers = jeiHelpers;
        this.fluidStack = stack;
        this.power = power;
        this.energy = energy;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public void getIngredients(IIngredients iIngredients) {
        iIngredients.setInput(VanillaTypes.FLUID, (Object)this.fluidStack);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int xPos = recipeWidth - 8;
        int yPos = recipeHeight / 2 - minecraft.field_71466_p.field_78288_b;
        RenderUtils.drawTextAlignedRight(this.power + this.getPowerUnit() + "/t", xPos, yPos, Color.gray.getRGB());
        RenderUtils.drawTextAlignedRight(this.energy + this.getPowerUnit() + "/mB", xPos, yPos += minecraft.field_71466_p.field_78288_b + 2, Color.gray.getRGB());
    }

    public String getPowerUnit() {
        return EnergyUnit.RF.name;
    }
}

