/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.generic;

import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.plugins.vanilla.ingredients.fluid.FluidStackRenderer;
import mezz.jei.util.Translator;

public abstract class GenericRecipeCategory<T extends IRecipeWrapper>
implements IRecipeCategory<T> {
    protected IDrawable icon = null;
    private final IDrawable background;
    private final IDrawable slotBackground;
    private final String localizedName;
    private final FluidStackRenderer fluidStackRenderer = new FluidStackRenderer(1, false, 16, 16, null);
    public final int GUI_WIDTH;
    public final int GUI_HEIGHT;

    public GenericRecipeCategory(IGuiHelper guiHelper) {
        this(guiHelper, 116, 54);
    }

    public GenericRecipeCategory(IGuiHelper guiHelper, int width, int height) {
        this.background = guiHelper.createBlankDrawable(width, height);
        this.slotBackground = guiHelper.getSlotDrawable();
        this.localizedName = Translator.translateToLocal((String)this.getTranslationKey());
        this.GUI_WIDTH = width;
        this.GUI_HEIGHT = height;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public abstract String getTranslationKey();

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, T wrapper, IIngredients ingredients) {
    }

    public void addItemSlot(IGuiItemStackGroup guiItemStacks, int id, int x, int y) {
        guiItemStacks.init(id, true, x, y);
        guiItemStacks.setBackground(id, this.slotBackground);
    }

    public void addFluidSlot(IGuiFluidStackGroup guiFluidStackGroup, int id, int x, int y) {
        guiFluidStackGroup.init(id, true, (IIngredientRenderer)this.fluidStackRenderer, x, y, 18, 18, 1, 1);
        guiFluidStackGroup.setBackground(id, this.slotBackground);
    }
}

