/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.immersiveengineering;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalMultiblock;
import io.bluebeaker.mteenoughitems.jei.generic.FluidPowerRecipeCategory;
import io.bluebeaker.mteenoughitems.jei.generic.FluidPowerRecipeWrapper;
import io.bluebeaker.mteenoughitems.utils.EnergyUnit;
import io.bluebeaker.mteenoughitems.utils.ModChecker;
import io.bluebeaker.mteenoughitems.utils.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class DieselGeneratorCategory
extends FluidPowerRecipeCategory<Wrapper> {
    public static final String UID = "mteenoughitems.immersiveengineering.diesel_generator";

    public DieselGeneratorCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((Block)IEContent.blockMetalMultiblock, 1, BlockTypes_MetalMultiblock.DIESEL_GENERATOR.getMeta()));
    }

    public String getModName() {
        return ModChecker.ImmersiveEngineering.name;
    }

    @Override
    public String getTranslationKey() {
        return "tile.immersiveengineering.metal_multiblock.diesel_generator.name";
    }

    public String getUid() {
        return UID;
    }

    @Override
    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public static List<Wrapper> getRecipes(IJeiHelpers jeiHelpers) {
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        Map fuelValues = DieselHandler.getFuelValuesSorted((boolean)false);
        for (Map.Entry entry : fuelValues.entrySet()) {
            String name = (String)entry.getKey();
            int time = (Integer)entry.getValue();
            Fluid fluid1 = FluidRegistry.getFluid((String)name);
            if (fluid1 == null) continue;
            int power = Config.IEConfig.Machines.dieselGen_output;
            recipes.add(new Wrapper(jeiHelpers, new FluidStack(fluid1, 1000 / time), (long)power, (long)time));
        }
        return recipes;
    }

    public static class Wrapper
    extends FluidPowerRecipeWrapper {
        public Wrapper(IJeiHelpers jeiHelpers, FluidStack fluid, long power, long time) {
            super(jeiHelpers, fluid, power, time);
        }

        @Override
        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int xPos = recipeWidth - 8;
            int yPos = recipeHeight / 2 - minecraft.field_71466_p.field_78288_b;
            RenderUtils.drawTextAlignedRight(this.power + this.getPowerUnit() + "/t", xPos, yPos, Color.gray.getRGB());
            RenderUtils.drawTextAlignedRight(this.energy + "t/B", xPos, yPos += minecraft.field_71466_p.field_78288_b + 2, Color.gray.getRGB());
        }

        @Override
        public String getPowerUnit() {
            return EnergyUnit.RF.name;
        }
    }
}

